/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec.impls;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.refcodes.codec.BaseCodecBuilder;
import org.refcodes.codec.BaseCodecConfig;
import org.refcodes.codec.BaseCodecMetrics;
import org.refcodes.codec.BaseDecodeReceiver;
import org.refcodes.codec.impls.BaseCodecBuilderImpl;
import org.refcodes.codec.impls.BaseDecodeInputStreamReceiverImpl;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.VerifyMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.impls.RandomTextGenerartorImpl;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class BaseDecodeInputStreamReceiverTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected static final int WEAK_INTENSITY_LOOPS = 4096;
    protected static final int STRONG_INTENSITY_LOOPS = 10240;
    protected static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testSomeRandomText() throws OpenException, InterruptedException, CloseException {
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BIN);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.OCT);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.DEC);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.HEX);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE17);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE21);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE25);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE27);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE32);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE64);
    }

    @Test
    public void testSomeRandomBytes() throws OpenException, InterruptedException, CloseException {
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BIN);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.OCT);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.DEC);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.HEX);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE17);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE21);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE25);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE27);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE32);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE64);
    }

    @Ignore(value="Too time consuming for everyday builds")
    @Test
    public void testAllRandomText() throws OpenException, InterruptedException, CloseException {
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomTextTest((BaseCodecMetrics)eCodec);
        }
    }

    @Ignore(value="Too time consuming for everyday builds")
    @Test
    public void testAllRandomBytes() throws OpenException, InterruptedException, CloseException {
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomBytesTest((BaseCodecMetrics)eCodec);
        }
    }

    @Ignore(value="Just for debugging purposes")
    @Test
    public void debugBaseDecodeInputStreamTest1() throws OpenException, InterruptedException, CloseException {
        BaseCodecBuilder theBaseCodeBuilder = new BaseCodecBuilderImpl().withBaseCodecMetrics((BaseCodecMetrics)BaseCodecConfig.BIN);
        String theInputText = "Hello World!?";
        byte[] theInputBytes = theInputText.getBytes();
        String theEncodedText = theBaseCodeBuilder.withDecodedData(theInputBytes).getEncodedText();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theEncodedText.getBytes());
        BaseDecodeReceiver theDecodeReceiver = new BaseDecodeInputStreamReceiverImpl((InputStream)theInputStream).withBaseCodecMetrics((BaseCodecMetrics)BaseCodecConfig.BIN);
        ArrayList<Byte> theDecodedBytes = new ArrayList<Byte>();
        while (theDecodeReceiver.hasDatagram()) {
            byte[] eDecodedBytes;
            byte[] byArray = eDecodedBytes = theDecodeReceiver.readDatagrams();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eByte = byArray[i];
                theDecodedBytes.add(eByte);
            }
        }
        theDecodeReceiver.close();
        LOGGER.debug("Input   := " + new VerboseTextBuilderImpl().withElements(theInputBytes));
        LOGGER.debug("Decoded := " + new VerboseTextBuilderImpl().withElements(theDecodedBytes));
        String theDecodedText = new String(ArrayUtils.toPrimitive((Byte[])theDecodedBytes.toArray(new Byte[theDecodedBytes.size()])));
        LOGGER.debug("Expecting <" + theDecodedText + "> to be <" + theInputText + "> ...");
        Assert.assertEquals((Object)theInputText, (Object)theDecodedText);
    }

    private void runRandomTextTest(BaseCodecMetrics aBaseCodecMetrics) throws OpenException, InterruptedException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseCodecMetrics.getNumberBase() + "> ...");
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 4096; ++i) {
            theRndGen.withColumnWidth(i % 4096);
            String eRndText = (String)theRndGen.next();
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecodeReceiver eDecodeReceiver = new BaseDecodeInputStreamReceiverImpl((InputStream)eInputStream).withBaseCodecMetrics(aBaseCodecMetrics);
            ArrayList<Byte> eDecodedBytes = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedBytes.add(eByte);
                }
            }
            eDecodeReceiver.close();
            String eDecodedText = new String(ArrayUtils.toPrimitive((Byte[])eDecodedBytes.toArray(new Byte[eDecodedBytes.size()])));
            Assert.assertEquals((Object)eRndText, (Object)eDecodedText);
        }
    }

    private void runRandomBytesTest(BaseCodecMetrics aBaseCodecMetrics) throws OpenException, InterruptedException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseCodecMetrics.getNumberBase() + "> ...");
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 4096; ++i) {
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecodeReceiver eDecodeReceiver = new BaseDecodeInputStreamReceiverImpl((InputStream)eInputStream).withBaseCodecMetrics(aBaseCodecMetrics);
            ArrayList<Byte> eDecodedByteList = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedByteList.add(eByte);
                }
            }
            eDecodeReceiver.close();
            byte[] eDecodedBytes = ArrayUtils.toPrimitive((Byte[])eDecodedByteList.toArray(new Byte[eDecodedByteList.size()]));
            Assert.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
        }
    }
}

