/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec.impls;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.refcodes.codec.BaseCodecBuilder;
import org.refcodes.codec.BaseCodecConfig;
import org.refcodes.codec.BaseCodecMetrics;
import org.refcodes.codec.BaseEncodeSender;
import org.refcodes.codec.impls.BaseCodecBuilderImpl;
import org.refcodes.codec.impls.BaseEncodeOutputStreamSenderImpl;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.VerifyMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.impls.RandomTextGenerartorImpl;

public class BaseEncodeOutputStreamSenderTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected static final int WEAK_INTENSITY_LOOPS = 4096;
    protected static final int STRONG_INTENSITY_LOOPS = 10240;
    protected static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testSomeRandomText() throws OpenException, CloseException {
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BIN);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.OCT);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.DEC);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.HEX);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE17);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE21);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE25);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE27);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE32);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE64);
    }

    @Test
    public void testSomeRandomBytes() throws OpenException, CloseException {
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BIN);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.OCT);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.DEC);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.HEX);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE17);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE21);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE25);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE27);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE32);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE64);
    }

    @Ignore(value="Too time consuming for everyday builds")
    @Test
    public void testAllRandomText() throws OpenException, CloseException {
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomTextTest((BaseCodecMetrics)eCodec);
        }
    }

    @Ignore(value="Too time consuming for everyday builds")
    @Test
    public void testAllRandomBytes() throws OpenException, CloseException {
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomBytesTest((BaseCodecMetrics)eCodec);
        }
    }

    @Ignore(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream1() throws OpenException, CloseException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseCodecConfig theCodecMetrics = BaseCodecConfig.BASE64;
        BaseCodecBuilder theBaseCodeBuilder = new BaseCodecBuilderImpl().withBaseCodecMetrics((BaseCodecMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncodeSender theEncodeSender = new BaseEncodeOutputStreamSenderImpl((OutputStream)theOutputStream).withBaseCodecMetrics((BaseCodecMetrics)theCodecMetrics);
        theEncodeSender.writeDatagrams(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        LOGGER.debug("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        Assert.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    @Ignore(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream2() throws OpenException, CloseException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseCodecConfig theCodecMetrics = BaseCodecConfig.BASE64;
        BaseCodecBuilder theBaseCodeBuilder = new BaseCodecBuilderImpl().withBaseCodecMetrics((BaseCodecMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncodeSender theEncodeSender = new BaseEncodeOutputStreamSenderImpl((OutputStream)theOutputStream).withBaseCodecMetrics((BaseCodecMetrics)theCodecMetrics);
        theEncodeSender.writeDatagrams(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        LOGGER.debug("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        Assert.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    private void runRandomTextTest(BaseCodecMetrics aBaseCodecMetrics) throws OpenException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseCodecMetrics.getNumberBase() + "> ...");
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncodeSender eBaseEncodeOutputStream = new BaseEncodeOutputStreamSenderImpl((OutputStream)eOutputStream).withBaseCodecMetrics(aBaseCodecMetrics);
            theRndGen.withColumnWidth(i % 4096);
            String eRndText = (String)theRndGen.next();
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.writeDatagrams(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assert.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assert.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseCodecMetrics != BaseCodecConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assert.assertEquals((String)"Expecting our BASE64 encoding to be compatible with standard Java 8 encoding!", (Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseCodecMetrics aBaseCodecMetrics) throws OpenException, CloseException {
        LOGGER.info("Running random bytes tests for base <" + aBaseCodecMetrics.getNumberBase() + "> ...");
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncodeSender eBaseEncodeOutputStream = new BaseEncodeOutputStreamSenderImpl((OutputStream)eOutputStream).withBaseCodecMetrics(aBaseCodecMetrics);
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.writeDatagrams(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assert.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assert.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseCodecMetrics != BaseCodecConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assert.assertEquals((String)"Expecting our BASE64 encoding to be compatible with standard Java 8 encoding!", (Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }
}

