/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.refcodes.codec.ChannelSelector;
import org.refcodes.codec.ModemEncoder;
import org.refcodes.codec.ModemMetrics;
import org.refcodes.codec.ModulationFormat;
import org.refcodes.codec.ModulatorStatus;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectableComponent;
import org.refcodes.component.OpenException;
import org.refcodes.component.Openable;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.ByteConsumer;
import org.refcodes.io.ByteSender;
import org.refcodes.io.ByteSenderDecorator;
import org.refcodes.io.ShortConsumer;
import org.refcodes.io.ShortSender;
import org.refcodes.io.ShortSenderDecorator;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class ModemEncoderImpl
extends AbstractConnectableAutomaton
implements ModemEncoder {
    private static final int SILENCE_BITS = 3;
    private static final int POST_CARRIER_BITS = 1;
    private static final int PRE_CARRIER_BITS = 3;
    private static final int ENCODER_DATA_BUFFER_SIZE = 128;
    private ModemMetrics _modemMetrics;
    private ShortConsumer _shortConsumer;
    private ByteConsumer _byteConsumer;
    public ModulatorStatus _modulatorStatus = ModulatorStatus.IDLE;
    private ShortBuffer _shortBuffer;
    private ByteBuffer _byteBuffer;
    private ByteBuffer _dataBuffer;
    private int _signalLength = 0;
    private int _dataLength = 0;
    private int _dataPointer = 0;

    public ModemEncoderImpl(ModemMetrics aModemMetrics, ByteConsumer aByteConsumer) {
        this(aModemMetrics);
        try {
            this.open((ByteConsumer)new ByteSenderDecorator(aByteConsumer));
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    public ModemEncoderImpl(ModemMetrics aModemMetrics, ShortConsumer aShortConsumer) {
        this(aModemMetrics);
        try {
            this.open((ShortConsumer)new ShortSenderDecorator(aShortConsumer));
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    public ModemEncoderImpl(ModemMetrics aModemMetrics, ByteSender aByteSender) throws OpenException {
        this(aModemMetrics);
        this.open((ByteConsumer)aByteSender);
    }

    public ModemEncoderImpl(ModemMetrics aModemMetrics, ShortSender aShortSender) throws OpenException {
        this(aModemMetrics);
        this.open((ShortConsumer)aShortSender);
    }

    protected ModemEncoderImpl(ModemMetrics aModemMetrics) {
        this._modemMetrics = aModemMetrics;
    }

    public void writeDatagrams(byte[] aDatagrams, int aOffset, int aLength) throws OpenException {
        this.encode(aDatagrams, aOffset, aLength);
    }

    @Override
    public ModulatorStatus getModulatorStatus() {
        return this._modulatorStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws OpenException {
        while (this._modulatorStatus != ModulatorStatus.IDLE) {
            ModemEncoderImpl modemEncoderImpl = this;
            synchronized (modemEncoderImpl) {
                try {
                    this.wait(LoopSleepTime.MIN.getMilliseconds());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void open() throws OpenException {
        super.open();
    }

    public void close() throws CloseException {
        this.stop();
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void open(ShortConsumer aConnection) throws OpenException {
        if (this._modemMetrics.getModulationFormat() != ModulationFormat.SHORT) {
            throw new IllegalArgumentException("When configuring a modulation format other than <" + ModulationFormat.SHORT + ">, then you must not pass a Short-Consumer.");
        }
        this._shortConsumer = aConnection;
        if (this._shortConsumer instanceof ConnectableComponent.ConnectableAutomaton) {
            ConnectableComponent.ConnectableAutomaton theConnectable = (ConnectableComponent.ConnectableAutomaton)this._shortConsumer;
            if (!theConnectable.isOpened()) {
                if (!(this._shortConsumer instanceof Openable)) throw new OpenException("The provided connection is in status <" + theConnectable.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
                ((Openable)this._shortConsumer).open();
            }
        } else if (this._shortConsumer instanceof Openable) {
            ((Openable)this._shortConsumer).open();
        }
        this.open();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void open(ByteConsumer aConnection) throws OpenException {
        if (this._modemMetrics.getModulationFormat() != ModulationFormat.BYTE) {
            throw new IllegalArgumentException("When configuring a modulation format other than <" + ModulationFormat.BYTE + ">, then you must not pass a Byte-Consumer.");
        }
        this._byteConsumer = aConnection;
        if (this._byteConsumer instanceof ConnectableComponent.ConnectableAutomaton) {
            ConnectableComponent.ConnectableAutomaton theConnectable = (ConnectableComponent.ConnectableAutomaton)this._byteConsumer;
            if (!theConnectable.isOpened()) {
                if (!(this._byteConsumer instanceof Openable)) throw new OpenException("The provided connection is in status <" + theConnectable.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
                ((Openable)this._byteConsumer).open();
            }
        } else if (this._byteConsumer instanceof Openable) {
            ((Openable)this._byteConsumer).open();
        }
        this.open();
    }

    private void stop() {
    }

    private void nextStatus() {
        switch (this._modulatorStatus) {
            case IDLE: {
                this._modulatorStatus = ModulatorStatus.PRE_CARRIER;
                break;
            }
            case PRE_CARRIER: {
                this._modulatorStatus = ModulatorStatus.ENCODING;
                break;
            }
            case ENCODING: {
                this._modulatorStatus = ModulatorStatus.POST_CARRIER;
                break;
            }
            case POST_CARRIER: {
                this._modulatorStatus = ModulatorStatus.SILENCE;
                break;
            }
            case SILENCE: {
                this._modulatorStatus = ModulatorStatus.IDLE;
            }
        }
    }

    private void purge() {
        if (this._dataPointer <= this._dataLength) {
            byte[] theCurrentData = this._dataBuffer.array();
            byte[] theRemainingData = new byte[this._dataLength - this._dataPointer];
            for (int i = 0; i < theRemainingData.length; ++i) {
                theRemainingData[i] = theCurrentData[this._dataPointer + i];
            }
            this._dataBuffer = ByteBuffer.allocate(128);
            this._dataBuffer.put(theRemainingData);
            this._dataBuffer.rewind();
            this._dataPointer = 0;
            this._dataLength = theRemainingData.length;
        } else {
            this.clearData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearData() {
        ByteBuffer byteBuffer = this._dataBuffer;
        synchronized (byteBuffer) {
            this.initBuffer();
            this._dataLength = 0;
            this._dataPointer = 0;
            this._dataBuffer.capacity();
        }
    }

    private void flushOn() throws OpenException {
        if (this._signalLength > 0) {
            if (this._modemMetrics.getModulationFormat() == ModulationFormat.BYTE) {
                byte[] dataPCM8 = new byte[this._signalLength];
                for (int i = 0; i < this._signalLength; ++i) {
                    dataPCM8[i] = this._byteBuffer.get(i);
                }
                if (dataPCM8 != null && this._byteConsumer != null) {
                    this._byteConsumer.writeDatagrams(dataPCM8);
                }
            } else if (this._modemMetrics.getModulationFormat() == ModulationFormat.SHORT) {
                short[] dataPCM16 = new short[this._signalLength];
                for (int i = 0; i < this._signalLength; ++i) {
                    dataPCM16[i] = this._shortBuffer.get(i);
                }
                if (dataPCM16 != null && this._shortConsumer != null) {
                    this._shortConsumer.writeDatagrams(dataPCM16);
                }
            }
            this._signalLength = 0;
            this.initBuffer();
        }
    }

    private void flushOnInsufficientCapacity() throws OpenException {
        switch (this._modemMetrics.getModulationFormat()) {
            case BYTE: {
                if (this._signalLength < this._byteBuffer.capacity() - 2) break;
                this.flushOn();
                break;
            }
            case SHORT: {
                if (this._signalLength < this._shortBuffer.capacity() - 2) break;
                this.flushOn();
                break;
            }
            default: {
                throw new IllegalStateException("The Modem-Metric's Modulation-Format is not set but must be set to one of the following: " + new VerboseTextBuilderImpl().withElements((Object[])ModulationFormat.values()));
            }
        }
    }

    private void doModulateSignal(SignalStatus aSignalStatus) throws OpenException {
        block13: {
            block11: {
                block12: {
                    if (aSignalStatus.equals((Object)SignalStatus.SILENCE)) break block11;
                    if (this._modemMetrics.getModulationFormat() != ModulationFormat.BYTE) break block12;
                    byte[] theData = this.toByteSignal(aSignalStatus);
                    this._byteBuffer.position(this._signalLength);
                    for (int i = 0; i < this._modemMetrics.toSamplesPerBit(); ++i) {
                        this._byteBuffer.put(theData[i]);
                        ++this._signalLength;
                        if (this._modemMetrics.getChannelSelector() == ChannelSelector.STEREO) {
                            this._byteBuffer.put(theData[i]);
                            ++this._signalLength;
                        }
                        this.flushOnInsufficientCapacity();
                    }
                    break block13;
                }
                if (this._modemMetrics.getModulationFormat() != ModulationFormat.SHORT) break block13;
                short[] theData = this.toShortSignal(aSignalStatus);
                for (int i = 0; i < this._modemMetrics.toSamplesPerBit(); ++i) {
                    this._shortBuffer.put(theData[i]);
                    ++this._signalLength;
                    if (this._modemMetrics.getChannelSelector() == ChannelSelector.STEREO) {
                        this._shortBuffer.put(theData[i]);
                        ++this._signalLength;
                    }
                    this.flushOnInsufficientCapacity();
                }
                break block13;
            }
            if (this._modemMetrics.getModulationFormat() == ModulationFormat.BYTE) {
                this._byteBuffer.position(this._signalLength);
                for (int i = 0; i < this._modemMetrics.toSamplesPerBit(); ++i) {
                    this._byteBuffer.put((byte)0);
                    ++this._signalLength;
                    if (this._modemMetrics.getChannelSelector() == ChannelSelector.STEREO) {
                        this._byteBuffer.put((byte)0);
                        ++this._signalLength;
                    }
                    this.flushOnInsufficientCapacity();
                }
            } else if (this._modemMetrics.getModulationFormat() == ModulationFormat.SHORT) {
                this._shortBuffer.position(this._signalLength);
                for (int i = 0; i < this._modemMetrics.toSamplesPerBit(); ++i) {
                    this._shortBuffer.put((short)0);
                    ++this._signalLength;
                    if (this._modemMetrics.getChannelSelector() == ChannelSelector.STEREO) {
                        this._shortBuffer.put((short)0);
                        ++this._signalLength;
                    }
                    this.flushOnInsufficientCapacity();
                }
            }
        }
    }

    private byte[] toByteSignal(SignalStatus aSignalStatus) {
        int theFrequency = 0;
        byte[] theBuffer = new byte[this._modemMetrics.toSamplesPerBit()];
        theFrequency = aSignalStatus.equals((Object)SignalStatus.HIGH) ? this._modemMetrics.getModemMode().getHigherFrequency() : this._modemMetrics.getModemMode().getLowerFrequency();
        for (int i = 0; i < theBuffer.length; ++i) {
            theBuffer[i] = (byte)(128.0 + 127.0 * Math.sin(Math.PI * 2 * (double)((float)i * 1.0f / (float)this._modemMetrics.getSampleRate().getValue().intValue()) * (double)theFrequency));
        }
        return theBuffer;
    }

    private short[] toShortSignal(SignalStatus aSignalStatus) {
        int theFrequency = 0;
        short[] theBuffer = new short[this._modemMetrics.toSamplesPerBit()];
        theFrequency = aSignalStatus.equals((Object)SignalStatus.HIGH) ? this._modemMetrics.getModemMode().getHigherFrequency() : this._modemMetrics.getModemMode().getLowerFrequency();
        for (int i = 0; i < theBuffer.length; ++i) {
            theBuffer[i] = (short)(32767.0 * Math.sin(Math.PI * 2 * (double)((float)i * 1.0f / (float)this._modemMetrics.getSampleRate().getValue().intValue()) * (double)theFrequency));
        }
        return theBuffer;
    }

    private void doCarrierCycle() throws OpenException {
        if (this._modulatorStatus.equals((Object)ModulatorStatus.PRE_CARRIER)) {
            for (int i = 0; i < 3; ++i) {
                this.doModulateSignal(SignalStatus.HIGH);
            }
        } else if (this._modulatorStatus.equals((Object)ModulatorStatus.POST_CARRIER)) {
            for (int i = 0; i < 1; ++i) {
                this.doModulateSignal(SignalStatus.HIGH);
            }
        }
        this.nextStatus();
    }

    private void doEncodingCycle() throws OpenException {
        if (this._dataPointer < this._dataLength) {
            this._dataBuffer.position(this._dataPointer);
            byte theData = this._dataBuffer.get();
            this.doModulateSignal(SignalStatus.LOW);
            for (byte mask = 1; mask != 0; mask = (byte)(mask << 1)) {
                if ((theData & mask) > 0) {
                    this.doModulateSignal(SignalStatus.HIGH);
                    continue;
                }
                this.doModulateSignal(SignalStatus.LOW);
            }
            this.doModulateSignal(SignalStatus.HIGH);
            ++this._dataPointer;
        } else {
            this.nextStatus();
        }
    }

    private void doSilenceCycle() throws OpenException {
        for (int i = 0; i < 3; ++i) {
            this.doModulateSignal(SignalStatus.SILENCE);
        }
        this.flushOn();
        this.nextStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encode(byte[] data, int aOffset, int aLength) throws OpenException {
        this._dataBuffer = ByteBuffer.allocate(data.length);
        this._dataBuffer.put(data, aOffset, aLength);
        this._dataLength = data.length;
        this._modulatorStatus = ModulatorStatus.PRE_CARRIER;
        this.initBuffer();
        while (this._modulatorStatus != ModulatorStatus.IDLE && this.isOpened()) {
            ByteBuffer byteBuffer = this._dataBuffer;
            synchronized (byteBuffer) {
                switch (this._modulatorStatus) {
                    case IDLE: {
                        this.stop();
                        break;
                    }
                    case PRE_CARRIER: 
                    case POST_CARRIER: {
                        this.doCarrierCycle();
                        break;
                    }
                    case ENCODING: {
                        this.doEncodingCycle();
                        ModemEncoderImpl modemEncoderImpl = this;
                        synchronized (modemEncoderImpl) {
                            this.notifyAll();
                            break;
                        }
                    }
                    case SILENCE: {
                        this.doSilenceCycle();
                    }
                }
            }
        }
    }

    private void initBuffer() {
        if (this._modemMetrics.getModulationFormat() == ModulationFormat.BYTE) {
            this._byteBuffer = ByteBuffer.allocate(this._modemMetrics.getSampleRate().getValue());
        } else if (this._modemMetrics.getModulationFormat() == ModulationFormat.SHORT) {
            this._shortBuffer = ShortBuffer.allocate(this._modemMetrics.getSampleRate().getValue());
        }
    }

    private static enum SignalStatus {
        HIGH,
        LOW,
        SILENCE;

    }
}

