/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseBuilderImpl;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseDecoder;
import org.refcodes.codec.BaseInputStreamDecoderImpl;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class BaseInputStreamDecoderTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int WEAK_INTENSITY_LOOPS = 4096;
    private static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testAllRandomText() throws OpenException, InterruptedException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec);
        }
    }

    @Test
    public void testAllRandomBytes() throws OpenException, InterruptedException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec);
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseDecodeInputStreamTest1() throws OpenException, InterruptedException, CloseException {
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)BaseConfig.BINARY);
        String theInputText = "Hello World!?";
        byte[] theInputBytes = theInputText.getBytes();
        String theEncodedText = theBaseCodeBuilder.withDecodedData(theInputBytes).getEncodedText();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theEncodedText.getBytes());
        BaseDecoder theDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)theInputStream).withBaseMetrics((BaseMetrics)BaseConfig.BINARY);
        ArrayList<Byte> theDecodedBytes = new ArrayList<Byte>();
        while (theDecodeReceiver.hasDatagram()) {
            byte[] eDecodedBytes;
            byte[] byArray = eDecodedBytes = theDecodeReceiver.readDatagrams();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eByte = byArray[i];
                theDecodedBytes.add(eByte);
            }
        }
        theDecodeReceiver.close();
        LOGGER.info("Input   := " + new VerboseTextBuilderImpl().withElements(theInputBytes));
        LOGGER.info("Decoded := " + new VerboseTextBuilderImpl().withElements(theDecodedBytes));
        String theDecodedText = new String(ArrayUtils.toPrimitive((Byte[])theDecodedBytes.toArray(new Byte[theDecodedBytes.size()])));
        LOGGER.info("Expecting <" + theDecodedText + "> to be <" + theInputText + "> ...");
        Assertions.assertEquals((Object)theInputText, (Object)theDecodedText);
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics) throws OpenException, InterruptedException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            theRndGen.withColumnWidth(i % 4096);
            String eRndText = (String)theRndGen.next();
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedBytes = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedBytes.add(eByte);
                }
            }
            eDecodeReceiver.close();
            String eDecodedText = new String(ArrayUtils.toPrimitive((Byte[])eDecodedBytes.toArray(new Byte[eDecodedBytes.size()])));
            Assertions.assertEquals((Object)eRndText, (Object)eDecodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics) throws OpenException, InterruptedException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedByteList = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedByteList.add(eByte);
                }
            }
            eDecodeReceiver.close();
            byte[] eDecodedBytes = ArrayUtils.toPrimitive((Byte[])eDecodedByteList.toArray(new Byte[eDecodedByteList.size()]));
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
        }
    }
}

