/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseBuilderImpl;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseEncoder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseOutputStreamEncoderImpl;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;

public class BaseOutputStreamEncoderTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int WEAK_INTENSITY_LOOPS = 4096;
    private static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testAllRandomText() throws OpenException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec);
        }
    }

    @Test
    public void testAllRandomBytes() throws OpenException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec);
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream1() throws OpenException, CloseException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseConfig theCodecMetrics = BaseConfig.BASE64;
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncoder theEncodeSender = new BaseOutputStreamEncoderImpl((OutputStream)theOutputStream).withBaseMetrics((BaseMetrics)theCodecMetrics);
        theEncodeSender.writeDatagrams(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        LOGGER.info("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        Assertions.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream2() throws OpenException, CloseException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseConfig theCodecMetrics = BaseConfig.BASE64;
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncoder theEncodeSender = new BaseOutputStreamEncoderImpl((OutputStream)theOutputStream).withBaseMetrics((BaseMetrics)theCodecMetrics);
        theEncodeSender.writeDatagrams(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        LOGGER.info("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        Assertions.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics) throws OpenException, CloseException {
        LOGGER.info("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncoder eBaseEncodeOutputStream = new BaseOutputStreamEncoderImpl((OutputStream)eOutputStream).withBaseMetrics(aBaseMetrics);
            theRndGen.withColumnWidth(i % 4096);
            String eRndText = (String)theRndGen.next();
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.writeDatagrams(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assertions.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics) throws OpenException, CloseException {
        LOGGER.info("Running random bytes tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncoder eBaseEncodeOutputStream = new BaseOutputStreamEncoderImpl((OutputStream)eOutputStream).withBaseMetrics(aBaseMetrics);
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.writeDatagrams(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assertions.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }
}

