/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.data.CharSet;
import org.refcodes.data.Padding;
import org.refcodes.exception.BugException;

public class BaseMetricsImpl
implements BaseMetrics {
    private static final int BYTES_PER_INT = 4;
    private static final int BITS_PER_BYTE = 8;
    private Map<Character, Integer> _charToValueMap = new HashMap<Character, Integer>();
    private int _numberBase;
    private int _bytesPerInt;
    private char[] _charSet;
    private int _bitsPerDigit;
    private int _digitsPerInt;
    private int _digitsPerByte;
    private int _digitMask;
    private char _paddingChar;

    public BaseMetricsImpl(int aBase) {
        this(aBase, CharSet.BASE64.getCharSet());
    }

    public BaseMetricsImpl(int aBase, char[] aCharSet) {
        this(aBase, aCharSet, Padding.BASE64.getChar());
    }

    public BaseMetricsImpl(int aBase, char[] aCharSet, char aPaddingChar) {
        this._numberBase = aBase;
        this._charSet = aCharSet;
        this._bitsPerDigit = BaseMetricsImpl.toBitsPerDigit(aBase);
        this._digitMask = BaseMetricsImpl.toDigitMask(this._bitsPerDigit);
        this._bytesPerInt = BaseMetricsImpl.toBytesPerInt(this._bitsPerDigit);
        this._digitsPerInt = BaseMetricsImpl.toDigitsPerInt(this._bytesPerInt, this._bitsPerDigit);
        this._digitsPerByte = BaseMetricsImpl.toDigitsPerByte(aBase);
        this._paddingChar = aPaddingChar;
        this.intiCharToValueMap(aCharSet);
    }

    public BaseMetricsImpl(int aBase, int aBitsPerDigit, int aDigitsPerByte, int aDigitsPerInt, int aBytesPerInt, char[] aCharSet) {
        this(aBase, aBitsPerDigit, aDigitsPerByte, aDigitsPerInt, aBytesPerInt, aCharSet, Padding.BASE64.getChar());
    }

    public BaseMetricsImpl(int aBase, int aBitsPerDigit, int aDigitsPerByte, int aDigitsPerInt, int aBytesPerInt, char[] aCharSet, char aPaddingChar) {
        this._numberBase = aBase;
        this._charSet = aCharSet;
        this._digitMask = (int)Math.pow(2.0, aBitsPerDigit) - 1;
        this._bytesPerInt = aBytesPerInt;
        this._bitsPerDigit = aBitsPerDigit;
        this._digitsPerInt = aDigitsPerInt;
        this._digitsPerByte = aDigitsPerByte;
        this.intiCharToValueMap(aCharSet);
        this._paddingChar = aPaddingChar;
    }

    public BaseMetricsImpl(BaseMetrics aBaseMetrics) {
        this._bitsPerDigit = aBaseMetrics.getBitsPerDigit();
        this._bytesPerInt = aBaseMetrics.getBytesPerInt();
        this.intiCharToValueMap(aBaseMetrics.getCharSet());
        this._digitMask = aBaseMetrics.getDigitMask();
        this._digitsPerByte = aBaseMetrics.getDigitsPerByte();
        this._digitsPerInt = aBaseMetrics.getDigitsPerInt();
        this._numberBase = aBaseMetrics.getNumberBase();
        this._paddingChar = aBaseMetrics.getPaddingChar();
    }

    private void intiCharToValueMap(char[] aCharSet) {
        for (int i = 0; i < aCharSet.length; ++i) {
            this._charToValueMap.put(Character.valueOf(aCharSet[i]), i);
        }
    }

    public int getNumberBase() {
        return this._numberBase;
    }

    @Override
    public char[] getCharSet() {
        return this._charSet;
    }

    @Override
    public int getBytesPerInt() {
        return this._bytesPerInt;
    }

    @Override
    public int getDigitsPerInt() {
        return this._digitsPerInt;
    }

    @Override
    public int getBitsPerDigit() {
        return this._bitsPerDigit;
    }

    @Override
    public int getDigitsPerByte() {
        return this._digitsPerByte;
    }

    @Override
    public int getDigitMask() {
        return this._digitMask;
    }

    @Override
    public int toValue(char aChar) {
        if (aChar == this._paddingChar) {
            return 0;
        }
        return this._charToValueMap.get(Character.valueOf(aChar));
    }

    @Override
    public char toChar(int aValue) {
        return this._charSet[aValue];
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(base := " + this._numberBase + ", digits/int := " + this._digitsPerInt + ", bytes/int := " + this._bytesPerInt + ", bits/digit := " + this._bitsPerDigit + ")@" + this.hashCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._bytesPerInt;
        result = 31 * result + Arrays.hashCode(this._charSet);
        result = 31 * result + this._digitMask;
        result = 31 * result + this._digitsPerByte;
        result = 31 * result + this._numberBase;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseMetricsImpl other = (BaseMetricsImpl)obj;
        if (this._bytesPerInt != other._bytesPerInt) {
            return false;
        }
        if (!Arrays.equals(this._charSet, other._charSet)) {
            return false;
        }
        if (this._digitMask != other._digitMask) {
            return false;
        }
        if (this._digitsPerByte != other._digitsPerByte) {
            return false;
        }
        return this._numberBase == other._numberBase;
    }

    protected static int toDigitMask(int aBitsPerDigit) {
        return (int)Math.pow(2.0, aBitsPerDigit) - 1;
    }

    protected static int toBitsPerDigit(int aBase) {
        int theBitsPerDigit = Integer.toBinaryString(aBase - 1).length();
        while (8 % theBitsPerDigit != 0 && 16 % theBitsPerDigit != 0 && 24 % theBitsPerDigit != 0 && 32 % theBitsPerDigit != 0) {
            ++theBitsPerDigit;
        }
        return theBitsPerDigit;
    }

    protected static int toDigitsPerInt(int aBytesPerInt, int aBitsPerDigit) {
        return 8 * aBytesPerInt / aBitsPerDigit;
    }

    protected static int toDigitsPerByte(int aBase) {
        int theDigitsPerByte = 0;
        for (int eMax = 1; eMax < 255; eMax *= aBase) {
            ++theDigitsPerByte;
        }
        return theDigitsPerByte;
    }

    protected static int toBytesPerInt(int aBitsPerDigit) {
        int i;
        for (i = 32; i > 0; --i) {
            if (i % aBitsPerDigit != 0) continue;
            return i / 8;
        }
        for (i = 1; i <= aBitsPerDigit; ++i) {
            if (i * 8 % aBitsPerDigit != 0) continue;
            return i * 8 / 8;
        }
        throw new BugException("We must have encountered a bug as we cannot determine the word length for a base codec with <" + aBitsPerDigit + "> bits per digit.");
    }
}

