/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.util.Base64;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseBuilderImpl;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsImpl;
import org.refcodes.data.CharSet;

public class BaseBuilderTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int WEAK_INTENSITY_LOOPS = 10240;
    private static final int STRONG_INTENSITY_LOOPS = 150000;
    private static final int MAX_DATA_LENGTH = 8192;
    private static char[] CHAR_SET = CharSet.ALPHANUMERIC.getCharSet();
    private static Random RND = new Random();

    @Test
    public void testAllRandomText() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Test
    public void testAllRandomBytes() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugeEdgeCase() {
        BaseConfig theMetrics = BaseConfig.ENCODED_AS_NUMBER;
        if (IS_LOG_TESTS) {
            System.out.println(theMetrics);
        }
        BaseBuilder theBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)theMetrics);
        String theEncoded = theBuilder.toEncodedText("Hallo welt! 1234567890 ABC".getBytes());
        byte[] theDecoded = theBuilder.toDecodedData(theEncoded);
        if (IS_LOG_TESTS) {
            System.out.println(theEncoded);
        }
        if (IS_LOG_TESTS) {
            System.out.println(new String(theDecoded));
        }
    }

    @Test
    public void debugEncodedAsNumberCodec() {
        this.runRandomTextTest((BaseMetrics)BaseConfig.ENCODED_AS_NUMBER, false);
    }

    @Test
    public void debugBase64Codec() {
        BaseMetricsImpl theBase64 = new BaseMetricsImpl(64, CharSet.BASE64.getCharSet());
        this.runRandomTextTest((BaseMetrics)theBase64, true);
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugGetBytesFromText() {
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)BaseConfig.BASE64);
        theBaseCodeBuilder.withDecodedData("Hello world!".getBytes());
        if (IS_LOG_TESTS) {
            System.out.println(theBaseCodeBuilder.getEncodedText());
        }
    }

    @Disabled(value="Just for throughput measurement")
    @Test
    public void testEncodeRefcodes() {
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)BaseConfig.BASE64);
        for (int i = 0; i < 150000; ++i) {
            String theRndText = this.toRandom(i % 8192);
            byte[] eBytes = theRndText.getBytes();
            theBaseCodeBuilder.withDecodedData(eBytes).getEncodedText();
        }
    }

    @Disabled(value="Just for throughput measurement")
    @Test
    public void testEncodeJava() {
        for (int i = 0; i < 150000; ++i) {
            String theRndText = this.toRandom(i % 8192);
            byte[] eBytes = theRndText.getBytes();
            Base64.getEncoder().encodeToString(eBytes);
        }
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics, boolean isWithSideEffectFreeShortcut) {
        if (IS_LOG_TESTS) {
            System.out.println("Running random text tests for base <" + (aBaseMetrics.getNumberBase() < 10 ? "0" : "") + aBaseMetrics.getNumberBase() + "> (" + (isWithSideEffectFreeShortcut ? "*" : "?") + ") ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 10240; ++i) {
            String eRndText = this.toRandom(i % 8192);
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics, boolean isWithSideEffectFreeShortcut) {
        if (IS_LOG_TESTS) {
            System.out.println("Running random bytes tests for base <" + (aBaseMetrics.getNumberBase() < 10 ? "0" : "") + aBaseMetrics.getNumberBase() + "> (" + (isWithSideEffectFreeShortcut ? "*" : "?") + ") ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 10240; ++i) {
            int eMod = i % 8192;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private String toRandom(int aColumnWidth) {
        int theBound = CHAR_SET.length;
        char[] theRandom = new char[aColumnWidth];
        for (int i = 0; i < aColumnWidth; ++i) {
            theRandom[i] = CHAR_SET[RND.nextInt(theBound)];
        }
        return new String(theRandom);
    }
}

