/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseBuilderImpl;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseDecoder;
import org.refcodes.codec.BaseInputStreamDecoderImpl;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;

public class BaseInputStreamDecoderTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int WEAK_INTENSITY_LOOPS = 4096;
    private static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testAllRandomText() throws OpenException, InterruptedException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec);
        }
    }

    @Test
    public void testAllRandomBytes() throws OpenException, InterruptedException, CloseException {
        for (BaseConfig eCodec : BaseConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec);
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseDecodeInputStreamTest1() throws OpenException, InterruptedException, CloseException {
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics((BaseMetrics)BaseConfig.BINARY);
        String theInputText = "Hello World!?";
        byte[] theInputBytes = theInputText.getBytes();
        String theEncodedText = theBaseCodeBuilder.withDecodedData(theInputBytes).getEncodedText();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theEncodedText.getBytes());
        BaseDecoder theDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)theInputStream).withBaseMetrics((BaseMetrics)BaseConfig.BINARY);
        ArrayList<Byte> theDecodedBytes = new ArrayList<Byte>();
        while (theDecodeReceiver.hasDatagram()) {
            byte[] eDecodedBytes;
            byte[] byArray = eDecodedBytes = theDecodeReceiver.readDatagrams();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eByte = byArray[i];
                theDecodedBytes.add(eByte);
            }
        }
        theDecodeReceiver.close();
        String theDecodedText = new String(BaseInputStreamDecoderTest.toPrimitiveType(theDecodedBytes.toArray(new Byte[theDecodedBytes.size()])));
        Assertions.assertEquals((Object)theInputText, (Object)theDecodedText);
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics) throws OpenException, InterruptedException, CloseException {
        if (IS_LOG_TESTS) {
            System.out.println("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            String eRndText = this.toRandomText(i % 4096);
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedBytes = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedBytes.add(eByte);
                }
            }
            eDecodeReceiver.close();
            String eDecodedText = new String(BaseInputStreamDecoderTest.toPrimitiveType(eDecodedBytes.toArray(new Byte[eDecodedBytes.size()])));
            if (IS_LOG_TESTS) {
                System.out.println("Expecting <" + eDecodedText + "> to be <" + eRndText + "> ...");
            }
            Assertions.assertEquals((Object)eRndText, (Object)eDecodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics) throws OpenException, InterruptedException, CloseException {
        if (IS_LOG_TESTS) {
            System.out.println("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilderImpl().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseInputStreamDecoderImpl((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedByteList = new ArrayList<Byte>();
            while (eDecodeReceiver.hasDatagram()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.readDatagrams();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedByteList.add(eByte);
                }
            }
            eDecodeReceiver.close();
            byte[] eDecodedBytes = BaseInputStreamDecoderTest.toPrimitiveType(eDecodedByteList.toArray(new Byte[eDecodedByteList.size()]));
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
        }
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }

    private String toRandomText(int aLength) {
        String eText = UUID.randomUUID().toString();
        while (eText.length() < aLength) {
            eText = eText + UUID.randomUUID().toString();
        }
        return eText.substring(0, aLength);
    }
}

