/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.IOException;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseDecoder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.component.Openable;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.ByteProvider;
import org.refcodes.io.ByteReceiver;
import org.refcodes.io.ByteReceiverDecorator;

public class BaseDecoderImpl
extends AbstractConnectableAutomaton
implements BaseDecoder {
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_BYTE = 8;
    private ByteReceiver _byteReceiver;
    private BaseMetrics _baseCodecMetrics = BaseConfig.BASE64;
    private int _trailingBytes = 0;
    int _word = 0;
    private byte[] _decodedBytes = new byte[this._baseCodecMetrics.getBytesPerInt()];
    private int _readIndex = 0;

    public BaseDecoderImpl(ByteProvider aByteProvider) {
        try {
            this.open((ByteProvider)new ByteReceiverDecorator(aByteProvider));
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    public BaseDecoderImpl(ByteReceiver aByteReceiver) throws OpenException {
        this.open((ByteProvider)aByteReceiver);
    }

    protected BaseDecoderImpl() {
    }

    @Override
    public BaseMetrics getBaseMetrics() {
        return this._baseCodecMetrics;
    }

    @Override
    public void setBaseMetrics(BaseMetrics aBaseMetrics) {
        this._baseCodecMetrics = aBaseMetrics;
        this._decodedBytes = new byte[this._baseCodecMetrics.getBytesPerInt()];
    }

    @Override
    public BaseDecoder withBaseMetrics(BaseMetrics aBaseMetrics) {
        this.setBaseMetrics(aBaseMetrics);
        return this;
    }

    public boolean hasDatagram() throws OpenException {
        return this._byteReceiver.hasDatagram();
    }

    public byte[] readDatagrams() throws OpenException, InterruptedException {
        if (this._readIndex > 0) {
            byte[] theDecodedBytes = new byte[this._decodedBytes.length - this._readIndex];
            int l = 0;
            for (int i = this._readIndex; i < this._decodedBytes.length; ++i) {
                theDecodedBytes[l++] = this._decodedBytes[i];
            }
            this._readIndex = 0;
            return theDecodedBytes;
        }
        try {
            for (int l = 0; l < this._baseCodecMetrics.getDigitsPerInt(); ++l) {
                this._word <<= this._baseCodecMetrics.getBitsPerDigit();
                char eRead = (char)this._byteReceiver.readDatagram();
                if (eRead != this._baseCodecMetrics.getPaddingChar()) {
                    this._word |= this._baseCodecMetrics.toValue(eRead) & 0xFF;
                    continue;
                }
                ++this._trailingBytes;
            }
            for (int i = 0; i < this._baseCodecMetrics.getBytesPerInt(); ++i) {
                int theIndex = this._baseCodecMetrics.getBytesPerInt() - i - 1;
                this._decodedBytes[theIndex] = (byte)this._word;
                this._word >>= 8;
            }
            this._word = 0;
        }
        catch (IOException e) {
            throw new OpenException("Unable to read from the provided receiver <" + this._byteReceiver + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
        if (this._trailingBytes != 0) {
            int theLastBlockSize = this._baseCodecMetrics.getBytesPerInt() - this._trailingBytes;
            byte[] theDecodedBytes = new byte[theLastBlockSize];
            for (int i = 0; i < theLastBlockSize; ++i) {
                theDecodedBytes[i] = this._decodedBytes[i];
            }
            return theDecodedBytes;
        }
        return this._decodedBytes;
    }

    public byte readDatagram() throws OpenException, InterruptedException {
        if (this._readIndex == 0) {
            this.readDatagrams();
        }
        byte theDecodedByte = this._decodedBytes[this._readIndex++];
        if (this._readIndex >= this._decodedBytes.length) {
            this._readIndex = 0;
        }
        return theDecodedByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        BaseDecoderImpl baseDecoderImpl = this;
        synchronized (baseDecoderImpl) {
            this.notifyAll();
        }
    }

    public synchronized void close() throws CloseException {
        try {
            this._byteReceiver.close();
        }
        catch (IOException e) {
            throw new CloseException("Unable to close the receiver <" + this._byteReceiver + ">", (Throwable)e);
        }
        super.close();
    }

    protected void open(ByteProvider aConnection) throws OpenException {
        this._byteReceiver = aConnection instanceof ByteReceiver ? (ByteReceiver)aConnection : new ByteReceiverDecorator(aConnection);
        if (!this._byteReceiver.isOpened()) {
            if (this._byteReceiver instanceof Openable) {
                ((Openable)this._byteReceiver).open();
            } else {
                throw new OpenException("The provided connection is in status <" + this._byteReceiver.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
            }
        }
        this.open();
    }

    public static class BaseDecoderProviderImpl
    extends BaseDecoderImpl
    implements BaseDecoder.BaseDecoderProvider {
        @Override
        public void open(ByteProvider aConnection) throws OpenException {
            super.open(aConnection);
        }
    }
}

