// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.codec;

import org.refcodes.mixin.ValueAccessor;

/**
 * The Enum SampleRate.
 */
public enum SampleRate implements ValueAccessor<Integer> {
	/**
	 * Double of #MONO.
	 */
	STEREO(44100),
	/** Least common multiple for 126, 315, 630, 1225, 2450. */
	MONO(22050),

	RATE_29400(29400);

	private int _sampleRate;

	/**
	 * Instantiates a new sample rate.
	 *
	 * @param aSampleRate the sample rate
	 */
	private SampleRate( int aSampleRate ) {
		_sampleRate = aSampleRate;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getValue() {
		return _sampleRate;
	}

}
