/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseDecoderInputStream;
import org.refcodes.codec.BaseEncoderOutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.MemoryUnit;
import org.refcodes.io.FileUtility;
import org.refcodes.io.InputStreamByteReceiver;

public class BaseEncoderDecodeStreamTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    /*
     * Unable to fully structure code
     */
    @Test
    public void testBaseEncoderDecodeStream() throws IOException {
        theRnd = new Random();
        theMemUnits = new MemoryUnit[]{MemoryUnit.BYTE, MemoryUnit.KILOBYTE, MemoryUnit.MEGABYTE};
        var6_3 = BaseMetricsConfig.values();
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            eCodec = var6_3[var4_5];
            var10_10 = theMemUnits;
            var9_9 = theMemUnits.length;
            var8_8 = 0;
            while (var8_8 < var9_9) {
                eMemUnit = var10_10[var8_8];
                i = 1;
                while (i < 4) {
                    if (eCodec.getNumberBase() >= 16 || eMemUnit != MemoryUnit.MEGABYTE) {
                        eSize = eMemUnit.toBytes((long)i).longValue();
                        if (eMemUnit != MemoryUnit.BYTE) {
                            eSize += (long)theRnd.nextInt(32);
                        }
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println("Testing file size <" + eSize + "> for codec <" + eCodec + "> ...");
                        }
                        theBigFile = FileUtility.createRandomTempFile((long)eSize);
                        theEncodedFile = FileUtility.createTempFile();
                        theDecodedFile = FileUtility.createTempFile();
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println("Big file := " + theBigFile.getAbsolutePath());
                            System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
                            System.out.println("Decoded file := " + theDecodedFile.getAbsolutePath());
                        }
                        var17_16 = null;
                        var18_19 = null;
                        try {
                            theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
                            try {
                                theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)eCodec);
                                try {
                                    theBigInputStream.transferTo((OutputStream)theEncoderOutputStream);
                                }
                                finally {
                                    if (theEncoderOutputStream != null) {
                                        theEncoderOutputStream.close();
                                    }
                                }
                                ** if (theBigInputStream == null) goto lbl-1000
                            }
                            catch (Throwable var18_20) {
                                if (var17_16 == null) {
                                    var17_16 = var18_20;
                                } else if (var17_16 != var18_20) {
                                    var17_16.addSuppressed(var18_20);
                                }
                                if (theBigInputStream != null) {
                                    theBigInputStream.close();
                                }
                                throw var17_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                theBigInputStream.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_21) {
                            if (var17_16 == null) {
                                var17_16 = var18_21;
                            } else if (var17_16 != var18_21) {
                                var17_16.addSuppressed(var18_21);
                            }
                            throw var17_16;
                        }
                        var17_16 = null;
                        var18_19 = null;
                        try {
                            theDecoderInputStream = new BaseDecoderInputStream((InputStream)new BufferedInputStream(new FileInputStream(theEncodedFile)), (BaseMetrics)eCodec);
                            try {
                                theDecodedOutputStream = new BufferedOutputStream(new FileOutputStream(theDecodedFile));
                                try {
                                    theDecoderInputStream.transferTo(theDecodedOutputStream);
                                }
                                finally {
                                    if (theDecodedOutputStream != null) {
                                        theDecodedOutputStream.close();
                                    }
                                }
                                ** if (theDecoderInputStream == null) goto lbl-1000
                            }
                            catch (Throwable var18_22) {
                                if (var17_16 == null) {
                                    var17_16 = var18_22;
                                } else if (var17_16 != var18_22) {
                                    var17_16.addSuppressed(var18_22);
                                }
                                if (theDecoderInputStream != null) {
                                    theDecoderInputStream.close();
                                }
                                throw var17_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                theDecoderInputStream.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_23) {
                            if (var17_16 == null) {
                                var17_16 = var18_23;
                            } else if (var17_16 != var18_23) {
                                var17_16.addSuppressed(var18_23);
                            }
                            throw var17_16;
                        }
                        if (!FileUtility.isEqual((File)theBigFile, (File)theDecodedFile)) {
                            Assertions.fail((String)"The files are not(!) equal!");
                        }
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println();
                        }
                    }
                    ++i;
                }
                ++var8_8;
            }
            ++var4_5;
        }
        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
            System.out.println("Done!");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testBaseEncoderDecodeStreamSkipWhiteSpaces() throws IOException {
        theRnd = new Random();
        theMemUnits = new MemoryUnit[]{MemoryUnit.BYTE, MemoryUnit.KILOBYTE};
        var6_3 = BaseMetricsConfig.values();
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            eCodec = var6_3[var4_5];
            var10_10 = theMemUnits;
            var9_9 = theMemUnits.length;
            var8_8 = 0;
            while (var8_8 < var9_9) {
                eMemUnit = var10_10[var8_8];
                i = 1;
                while (i < 4) {
                    if (eCodec.getNumberBase() >= 16) {
                        eSize = eMemUnit.toBytes((long)i).longValue();
                        if (eMemUnit != MemoryUnit.BYTE) {
                            eSize += (long)theRnd.nextInt(32);
                        }
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println("Testing file size <" + eSize + "> for codec <" + eCodec + "> ...");
                        }
                        theBigFile = FileUtility.createRandomTempFile((long)eSize);
                        theEncodedFile = FileUtility.createTempFile();
                        theDecodedFile = FileUtility.createTempFile();
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println("Big file := " + theBigFile.getAbsolutePath());
                            System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
                            System.out.println("Decoded file := " + theDecodedFile.getAbsolutePath());
                        }
                        var17_16 = null;
                        var18_19 = null;
                        try {
                            theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
                            try {
                                theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)eCodec);
                                try {
                                    theBigInputStream.transferTo((OutputStream)theEncoderOutputStream);
                                }
                                finally {
                                    if (theEncoderOutputStream != null) {
                                        theEncoderOutputStream.close();
                                    }
                                }
                                ** if (theBigInputStream == null) goto lbl-1000
                            }
                            catch (Throwable var18_20) {
                                if (var17_16 == null) {
                                    var17_16 = var18_20;
                                } else if (var17_16 != var18_20) {
                                    var17_16.addSuppressed(var18_20);
                                }
                                if (theBigInputStream != null) {
                                    theBigInputStream.close();
                                }
                                throw var17_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                theBigInputStream.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_21) {
                            if (var17_16 == null) {
                                var17_16 = var18_21;
                            } else if (var17_16 != var18_21) {
                                var17_16.addSuppressed(var18_21);
                            }
                            throw var17_16;
                        }
                        var17_16 = null;
                        var18_19 = null;
                        try {
                            theDecoderInputStream = new BaseDecoderInputStream((InputStream)new BufferedInputStream(new FileInputStream(theEncodedFile)), (BaseMetrics)eCodec, true);
                            try {
                                theDecodedOutputStream = new BufferedOutputStream(new FileOutputStream(theDecodedFile));
                                try {
                                    theDecoderInputStream.transferTo(theDecodedOutputStream);
                                }
                                finally {
                                    if (theDecodedOutputStream != null) {
                                        theDecodedOutputStream.close();
                                    }
                                }
                                ** if (theDecoderInputStream == null) goto lbl-1000
                            }
                            catch (Throwable var18_22) {
                                if (var17_16 == null) {
                                    var17_16 = var18_22;
                                } else if (var17_16 != var18_22) {
                                    var17_16.addSuppressed(var18_22);
                                }
                                if (theDecoderInputStream != null) {
                                    theDecoderInputStream.close();
                                }
                                throw var17_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                theDecoderInputStream.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_23) {
                            if (var17_16 == null) {
                                var17_16 = var18_23;
                            } else if (var17_16 != var18_23) {
                                var17_16.addSuppressed(var18_23);
                            }
                            throw var17_16;
                        }
                        if (!FileUtility.isEqual((File)theBigFile, (File)theDecodedFile)) {
                            Assertions.fail((String)"The files are not(!) equal!");
                        }
                        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
                            System.out.println();
                        }
                    }
                    ++i;
                }
                ++var8_8;
            }
            ++var4_5;
        }
        if (BaseEncoderDecodeStreamTest.IS_LOG_TESTS) {
            System.out.println("Done!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @Disabled(value="Just for debugging edge cases")
    public void testEdgeCase() throws IOException {
        Object var4_7;
        Throwable throwable;
        File theEncodedFile;
        block43: {
            File theBigFile = FileUtility.createRandomTempFile((String)"temp_big", (long)MemoryUnit.BYTE.toBytes(16L).longValue(), (boolean)false);
            theEncodedFile = FileUtility.createTempFile((String)"temp_encoded", (boolean)false);
            if (IS_LOG_TESTS) {
                System.out.println("Big file := " + theBigFile.getAbsolutePath());
                System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
            }
            throwable = null;
            var4_7 = null;
            try {
                BufferedInputStream theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
                try {
                    block42: {
                        BaseEncoderOutputStream theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)BaseMetricsConfig.BASE64);
                        try {
                            block41: {
                                BufferedInputStream theEncodedInputStream = new BufferedInputStream(new FileInputStream(theEncodedFile));
                                try {
                                    try (BufferedInputStream theEncodedInputStream2 = new BufferedInputStream(new FileInputStream(theEncodedFile));){
                                        ((InputStream)theBigInputStream).transferTo((OutputStream)theEncoderOutputStream);
                                    }
                                    if (theEncodedInputStream == null) break block41;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (theEncodedInputStream == null) throw throwable;
                                    ((InputStream)theEncodedInputStream).close();
                                    throw throwable;
                                }
                                ((InputStream)theEncodedInputStream).close();
                            }
                            if (theEncoderOutputStream == null) break block42;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (theEncoderOutputStream == null) throw throwable;
                            theEncoderOutputStream.close();
                            throw throwable;
                        }
                        theEncoderOutputStream.close();
                    }
                    if (theBigInputStream == null) break block43;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (theBigInputStream == null) throw throwable;
                    ((InputStream)theBigInputStream).close();
                    throw throwable;
                }
                ((InputStream)theBigInputStream).close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        try {
            throwable = null;
            var4_7 = null;
            try {
                BufferedInputStream theEncodedInputStream = new BufferedInputStream(new FileInputStream(theEncodedFile));
                try {
                    try (BufferedInputStream theEncodedInputStream2 = new BufferedInputStream(new FileInputStream(theEncodedFile));){
                        InputStreamByteReceiver theReceiver = new InputStreamByteReceiver((InputStream)theEncodedInputStream);
                        while (true) {
                            if (!theReceiver.hasAvailable()) break;
                            char eByte = (char)theReceiver.receiveByte();
                            System.out.print(eByte);
                        }
                        System.out.println("\n---");
                        while (true) {
                            if (((InputStream)theEncodedInputStream2).available() == 0) {
                                System.out.println("\n---");
                                break;
                            }
                            char eByte = (char)((InputStream)theEncodedInputStream2).read();
                            System.out.print(eByte);
                        }
                    }
                    if (theEncodedInputStream == null) return;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (theEncodedInputStream == null) throw throwable;
                    ((InputStream)theEncodedInputStream).close();
                    throw throwable;
                }
                ((InputStream)theEncodedInputStream).close();
                return;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

