/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.IOException;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.ChannelSelector;
import org.refcodes.codec.FrequencyThreshold;
import org.refcodes.codec.ModemDecoderImpl;
import org.refcodes.codec.ModemEncoderImpl;
import org.refcodes.codec.ModemMetrics;
import org.refcodes.codec.ModemMetricsImpl;
import org.refcodes.codec.ModemMode;
import org.refcodes.codec.ModulationFormat;
import org.refcodes.codec.SampleRate;
import org.refcodes.data.SystemProperty;
import org.refcodes.data.Text;
import org.refcodes.io.LoopbackShortsReceiver;
import org.refcodes.io.LoopbackShortsTransmitter;
import org.refcodes.io.ShortArrayReceiver;
import org.refcodes.io.ShortsReceiver;
import org.refcodes.io.ShortsSource;
import org.refcodes.io.ShortsTransmitter;

public class ModemTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testModem1() throws IOException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        final ArrayList theEncoded = new ArrayList();
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, new ShortsSource(){

            public void transmitShorts(short[] aShorts, int aOffset, int aLength) throws IOException {
                int i = 0;
                while (i < aLength) {
                    theEncoded.add(aShorts[i + aOffset]);
                    ++i;
                }
            }
        });
        theEncoder.transmitAllBytes(Text.ARECIBO_MESSAGE.toString().getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortsReceiver)new ShortArrayReceiver(theEncoded));
        ArrayList<Byte> theDecoded = new ArrayList<Byte>();
        while (theDecoder.hasAvailable()) {
            theDecoded.add(theDecoder.receiveByte());
        }
        String theMessage = new String(ModemTest.toPrimitiveType(theDecoded.toArray(new Byte[theDecoded.size()])));
        String[] stringArray = theLines = theMessage.split(SystemProperty.LINE_SEPARATOR.getValue());
        int n = theLines.length;
        int n2 = 0;
        while (n2 < n) {
            String eLine = stringArray[n2];
            if (IS_LOG_TESTS) {
                System.out.println(eLine);
            }
            ++n2;
        }
        Assertions.assertEquals((Object)Text.ARECIBO_MESSAGE.toString(), (Object)theMessage);
    }

    @Test
    public void testModem2() throws IOException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        String theMessage = Text.ARECIBO_MESSAGE.toString();
        LoopbackShortsReceiver theReceiver = new LoopbackShortsReceiver(656532);
        LoopbackShortsTransmitter theSender = new LoopbackShortsTransmitter();
        theReceiver.open(theSender);
        theSender.open(theReceiver);
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, (ShortsTransmitter)theSender);
        theEncoder.transmitAllBytes(theMessage.getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortsReceiver)theReceiver);
        ArrayList<Byte> theDecoded = new ArrayList<Byte>();
        while (theDecoder.hasAvailable()) {
            theDecoded.add(theDecoder.receiveByte());
        }
        String theReceived = new String(ModemTest.toPrimitiveType(theDecoded.toArray(new Byte[theDecoded.size()])));
        String[] stringArray = theLines = theReceived.split(SystemProperty.LINE_SEPARATOR.getValue());
        int n = theLines.length;
        int n2 = 0;
        while (n2 < n) {
            String eLine = stringArray[n2];
            if (IS_LOG_TESTS) {
                System.out.println(eLine);
            }
            ++n2;
        }
        Assertions.assertEquals((Object)theMessage, (Object)theMessage);
    }

    @Test
    public void testModem3() throws IOException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        String theMessage = Text.ARECIBO_MESSAGE.toString();
        LoopbackShortsReceiver theReceiver = new LoopbackShortsReceiver(656532);
        LoopbackShortsTransmitter theSender = new LoopbackShortsTransmitter();
        theReceiver.open(theSender);
        theSender.open(theReceiver);
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, (ShortsTransmitter)theSender);
        theEncoder.transmitAllBytes(theMessage.getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortsReceiver)theReceiver);
        byte[] theData = null;
        byte[] eData = null;
        while (theDecoder.hasAvailable()) {
            eData = theDecoder.receiveAllBytes();
            if (theData == null) {
                theData = eData;
                continue;
            }
            byte[] tmpData = new byte[theData.length + eData.length];
            System.arraycopy(theData, 0, tmpData, 0, theData.length);
            System.arraycopy(eData, 0, tmpData, theData.length, eData.length);
            theData = tmpData;
        }
        String[] stringArray = theLines = new String(theData).split(SystemProperty.LINE_SEPARATOR.getValue());
        int n = theLines.length;
        int n2 = 0;
        while (n2 < n) {
            String eLine = stringArray[n2];
            if (IS_LOG_TESTS) {
                System.out.println(eLine);
            }
            ++n2;
        }
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        int i = 0;
        while (i < aBytes.length) {
            thePrimitives[i] = aBytes[i];
            ++i;
        }
        return thePrimitives;
    }
}

