/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseDecoderInputStream;
import org.refcodes.codec.BaseEncoderOutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.MemoryUnit;
import org.refcodes.io.FileUtility;
import org.refcodes.io.InputStreamByteReceiver;

public class BaseEncoderDecodeStreamTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testBaseEncoderDecodeStream() throws IOException {
        Random theRnd = new Random();
        MemoryUnit[] theMemUnits = new MemoryUnit[]{MemoryUnit.BYTE, MemoryUnit.KILOBYTE, MemoryUnit.MEGABYTE};
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            for (MemoryUnit eMemUnit : theMemUnits) {
                for (int i = 1; i < 4; ++i) {
                    if (eCodec.getNumberBase() < 16 && eMemUnit == MemoryUnit.MEGABYTE) continue;
                    long eSize = eMemUnit.toBytes((long)i).longValue();
                    if (eMemUnit != MemoryUnit.BYTE) {
                        eSize += (long)theRnd.nextInt(32);
                    }
                    if (IS_LOG_TEST_ENABLED) {
                        System.out.println("Testing file size <" + eSize + "> for codec <" + eCodec + "> ...");
                    }
                    File theBigFile = FileUtility.createRandomTempFile((long)eSize);
                    File theEncodedFile = FileUtility.createTempFile();
                    File theDecodedFile = FileUtility.createTempFile();
                    if (IS_LOG_TEST_ENABLED) {
                        System.out.println("Big file := " + theBigFile.getAbsolutePath());
                        System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
                        System.out.println("Decoded file := " + theDecodedFile.getAbsolutePath());
                    }
                    try (BufferedInputStream theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
                         BaseEncoderOutputStream theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)eCodec);){
                        ((InputStream)theBigInputStream).transferTo((OutputStream)theEncoderOutputStream);
                    }
                    try (BaseDecoderInputStream theDecoderInputStream = new BaseDecoderInputStream((InputStream)new BufferedInputStream(new FileInputStream(theEncodedFile)), (BaseMetrics)eCodec);
                         BufferedOutputStream theDecodedOutputStream = new BufferedOutputStream(new FileOutputStream(theDecodedFile));){
                        theDecoderInputStream.transferTo(theDecodedOutputStream);
                    }
                    if (!FileUtility.isEqual((File)theBigFile, (File)theDecodedFile)) {
                        Assertions.fail((String)"The files are not(!) equal!");
                    }
                    if (!IS_LOG_TEST_ENABLED) continue;
                    System.out.println();
                }
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Done!");
        }
    }

    @Test
    public void testBaseEncoderDecodeStreamSkipWhiteSpaces() throws IOException {
        Random theRnd = new Random();
        MemoryUnit[] theMemUnits = new MemoryUnit[]{MemoryUnit.BYTE, MemoryUnit.KILOBYTE};
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            for (MemoryUnit eMemUnit : theMemUnits) {
                for (int i = 1; i < 4; ++i) {
                    if (eCodec.getNumberBase() < 16) continue;
                    long eSize = eMemUnit.toBytes((long)i).longValue();
                    if (eMemUnit != MemoryUnit.BYTE) {
                        eSize += (long)theRnd.nextInt(32);
                    }
                    if (IS_LOG_TEST_ENABLED) {
                        System.out.println("Testing file size <" + eSize + "> for codec <" + eCodec + "> ...");
                    }
                    File theBigFile = FileUtility.createRandomTempFile((long)eSize);
                    File theEncodedFile = FileUtility.createTempFile();
                    File theDecodedFile = FileUtility.createTempFile();
                    if (IS_LOG_TEST_ENABLED) {
                        System.out.println("Big file := " + theBigFile.getAbsolutePath());
                        System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
                        System.out.println("Decoded file := " + theDecodedFile.getAbsolutePath());
                    }
                    try (BufferedInputStream theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
                         BaseEncoderOutputStream theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)eCodec);){
                        ((InputStream)theBigInputStream).transferTo((OutputStream)theEncoderOutputStream);
                    }
                    try (BaseDecoderInputStream theDecoderInputStream = new BaseDecoderInputStream((InputStream)new BufferedInputStream(new FileInputStream(theEncodedFile)), (BaseMetrics)eCodec, true);
                         BufferedOutputStream theDecodedOutputStream = new BufferedOutputStream(new FileOutputStream(theDecodedFile));){
                        theDecoderInputStream.transferTo(theDecodedOutputStream);
                    }
                    if (!FileUtility.isEqual((File)theBigFile, (File)theDecodedFile)) {
                        Assertions.fail((String)"The files are not(!) equal!");
                    }
                    if (!IS_LOG_TEST_ENABLED) continue;
                    System.out.println();
                }
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Done!");
        }
    }

    @Test
    @Disabled(value="Just for debugging edge cases")
    public void testEdgeCase() throws IOException {
        File theBigFile = FileUtility.createRandomTempFile((String)"temp_big", (long)MemoryUnit.BYTE.toBytes(16L).longValue(), (boolean)false);
        File theEncodedFile = FileUtility.createTempFile((String)"temp_encoded", (boolean)false);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Big file := " + theBigFile.getAbsolutePath());
            System.out.println("Encoded file := " + theEncodedFile.getAbsolutePath());
        }
        try (BufferedInputStream theBigInputStream = new BufferedInputStream(new FileInputStream(theBigFile));
             BaseEncoderOutputStream theEncoderOutputStream = new BaseEncoderOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(theEncodedFile)), (BaseMetrics)BaseMetricsConfig.BASE64);
             BufferedInputStream theEncodedInputStream = new BufferedInputStream(new FileInputStream(theEncodedFile));
             BufferedInputStream theEncodedInputStream2 = new BufferedInputStream(new FileInputStream(theEncodedFile));){
            ((InputStream)theBigInputStream).transferTo((OutputStream)theEncoderOutputStream);
        }
        try (BufferedInputStream theEncodedInputStream = new BufferedInputStream(new FileInputStream(theEncodedFile));
             BufferedInputStream theEncodedInputStream2 = new BufferedInputStream(new FileInputStream(theEncodedFile));){
            InputStreamByteReceiver theReceiver = new InputStreamByteReceiver((InputStream)theEncodedInputStream);
            while (theReceiver.hasAvailable()) {
                char eByte = (char)theReceiver.receiveByte();
                System.out.print(eByte);
            }
            System.out.println("\n---");
            while (((InputStream)theEncodedInputStream2).available() != 0) {
                char eByte = (char)((InputStream)theEncodedInputStream2).read();
                System.out.print(eByte);
            }
            System.out.println("\n---");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

