/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsAccessor;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.codec.Encoder;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.Openable;
import org.refcodes.io.ByteTransmitterDecorator;
import org.refcodes.io.BytesReceiver;
import org.refcodes.io.BytesSource;
import org.refcodes.io.BytesTransmitter;
import org.refcodes.io.OutputStreamBytesTransmitter;

public class BaseEncoder
extends AbstractConnectableAutomaton
implements BaseMetricsAccessor.BaseMetricsProperty,
BaseMetricsAccessor.BaseMetricsBuilder<BaseEncoder>,
Encoder {
    private static final int BYTE_MASK = 255;
    private static final int BYTES_PER_INT = 4;
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_PER_INT = 32;
    private BytesTransmitter _byteSender;
    private BaseMetrics _baseMetrics = BaseMetricsConfig.BASE64;
    private byte[] _buffer = new byte[this._baseMetrics.getBytesPerInt()];
    private int _index = 0;

    public BaseEncoder(OutputStream aOutputStream) throws IOException {
        this((BytesTransmitter)new OutputStreamBytesTransmitter(aOutputStream));
    }

    public BaseEncoder(OutputStream aOutputStream, BaseMetrics aBaseMetrics) throws IOException {
        this(new OutputStreamBytesTransmitter(aOutputStream), aBaseMetrics);
    }

    public BaseEncoder(BytesSource aByteConsumer) {
        try {
            this.open((BytesSource)new ByteTransmitterDecorator(aByteConsumer));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BaseEncoder(BytesTransmitter aByteSender) throws IOException {
        this.open((BytesSource)aByteSender);
    }

    public BaseEncoder(OutputStreamBytesTransmitter aOutputStreamBytesTransmitter, BaseMetrics aBaseMetrics) throws IOException {
        this((BytesTransmitter)aOutputStreamBytesTransmitter);
        this.setBaseMetrics(aBaseMetrics);
    }

    protected BaseEncoder() {
    }

    @Override
    public BaseMetrics getBaseMetrics() {
        return this._baseMetrics;
    }

    @Override
    public void setBaseMetrics(BaseMetrics aBaseMetrics) {
        this._baseMetrics = aBaseMetrics;
        this._buffer = new byte[this._baseMetrics.getBytesPerInt()];
    }

    @Override
    public BaseEncoder withBaseMetrics(BaseMetrics aBaseMetrics) {
        this.setBaseMetrics(aBaseMetrics);
        return this;
    }

    public void transmitByte(byte aByte) throws IOException {
        this._buffer[this._index % this._baseMetrics.getBytesPerInt()] = aByte;
        ++this._index;
        if (this._index % this._baseMetrics.getBytesPerInt() == 0) {
            this.toEncodedText(0);
        }
    }

    public void transmitAllBytes(byte[] aDatagram) throws IOException {
        byte[] byArray = aDatagram;
        int n = aDatagram.length;
        int n2 = 0;
        while (n2 < n) {
            byte eData = byArray[n2];
            this.transmitByte(eData);
            ++n2;
        }
    }

    public void transmitBytes(byte[] aDatagram, int aOffset, int aLength) throws IOException {
        int i = aOffset;
        while (i < aOffset + aLength) {
            this.transmitByte(aDatagram[i]);
            ++i;
        }
    }

    public void flush() throws IOException {
        this._byteSender.flush();
    }

    public synchronized void close() throws IOException {
        int theTrailingBytes = this._baseMetrics.toPaddingCharsNumber(this._index);
        try {
            if (theTrailingBytes != 0) {
                while (this._index % this._baseMetrics.getBytesPerInt() != 0) {
                    this._buffer[this._index % this._baseMetrics.getBytesPerInt()] = 0;
                    ++this._index;
                }
                this.toEncodedText(theTrailingBytes);
                int i = 0;
                while (i < theTrailingBytes) {
                    this._byteSender.transmitByte((byte)(this._baseMetrics.getPaddingChar() & 0xFF));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to finish off encoding.", e);
        }
        try {
            this._byteSender.flush();
            this._byteSender.close();
        }
        catch (IOException e) {
            throw new IOException("Unable to close the output stream <" + this._byteSender + ">.", e);
        }
        super.close();
    }

    protected void open(BytesSource aConnection) throws IOException {
        this._byteSender = aConnection instanceof BytesReceiver ? (BytesTransmitter)aConnection : new ByteTransmitterDecorator(aConnection);
        if (!this._byteSender.isOpened()) {
            if (this._byteSender instanceof Openable) {
                ((Openable)this._byteSender).open();
            } else {
                throw new IOException("The provided connection is in status <" + this._byteSender.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
            }
        }
        this.open();
    }

    private void toEncodedText(int aTrailingBytes) throws IOException {
        int theWord = BaseEncoder.toWord(this._buffer, 0, this._baseMetrics);
        theWord <<= 8 * (4 - this._baseMetrics.getBytesPerInt());
        int i = 0;
        while (i < this._baseMetrics.getDigitsPerInt() - aTrailingBytes) {
            int eByte = theWord >> 32 - this._baseMetrics.getBitsPerDigit() & this._baseMetrics.getDigitMask();
            this._byteSender.transmitByte((byte)(this._baseMetrics.toChar(eByte) & 0xFF));
            theWord <<= this._baseMetrics.getBitsPerDigit();
            ++i;
        }
    }

    private static int toWord(byte[] aDecodedData, int aOffset, BaseMetrics aBaseMetrics) {
        int eWord = 0;
        int i = 0;
        while (i < aBaseMetrics.getBytesPerInt()) {
            eWord <<= 8;
            if (aOffset + i < aDecodedData.length) {
                eWord |= aDecodedData[aOffset + i] & 0xFF;
            }
            ++i;
        }
        return eWord;
    }

    public static class BaseEncoderConnection
    extends BaseEncoder
    implements ConnectionComponent<BytesSource> {
        @Override
        public void open(BytesSource aConnection) throws IOException {
            super.open(aConnection);
        }
    }
}

