/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.data.CharSet;
import org.refcodes.data.PaddingChar;
import org.refcodes.exception.BugException;
import org.refcodes.textual.VerboseTextBuilder;

public class BaseMetricsImpl
implements BaseMetrics {
    private static final int BYTES_PER_INT = 4;
    private static final int BITS_PER_BYTE = 8;
    private final Map<Character, Integer> _charToValueMap = new HashMap<Character, Integer>();
    private int _numberBase;
    private int _bytesPerInt;
    private char[] _charSet;
    private int _bitsPerDigit;
    private int _digitsPerInt;
    private int _digitsPerByte;
    private int _digitMask;
    private char _paddingChar;
    private int _bytesPerBlock;

    public BaseMetricsImpl(int aBase) {
        this(aBase, CharSet.BASE64.getCharSet());
    }

    public BaseMetricsImpl(int aBase, char[] aCharSet) {
        this(aBase, aCharSet, PaddingChar.BASE64.getChar());
    }

    public BaseMetricsImpl(int aBase, char[] aCharSet, char aPaddingChar) {
        this._numberBase = aBase;
        this._charSet = aCharSet;
        this._bitsPerDigit = BaseMetricsImpl.toBitsPerDigit(aBase);
        this._digitMask = BaseMetricsImpl.toDigitMask(this._bitsPerDigit);
        this._bytesPerInt = BaseMetricsImpl.toBytesPerInt(this._bitsPerDigit);
        this._digitsPerInt = BaseMetricsImpl.toDigitsPerInt(this._bytesPerInt, this._bitsPerDigit);
        this._digitsPerByte = BaseMetricsImpl.toDigitsPerByte(aBase);
        this._paddingChar = aPaddingChar;
        this._bytesPerBlock = BaseMetricsImpl.toBytesPerBlock(this._bitsPerDigit);
        this.intiCharToValueMap(aCharSet);
    }

    public BaseMetricsImpl(int aBase, int aBitsPerDigit, int aDigitsPerByte, int aDigitsPerInt, int aBytesPerInt, char[] aCharSet) {
        this(aBase, aBitsPerDigit, aDigitsPerByte, aDigitsPerInt, aBytesPerInt, aCharSet, PaddingChar.BASE64.getChar());
    }

    public BaseMetricsImpl(int aBase, int aBitsPerDigit, int aDigitsPerByte, int aDigitsPerInt, int aBytesPerInt, char[] aCharSet, char aPaddingChar) {
        this._numberBase = aBase;
        this._charSet = aCharSet;
        this._digitMask = (int)Math.pow(2.0, aBitsPerDigit) - 1;
        this._bytesPerInt = aBytesPerInt;
        this._bitsPerDigit = aBitsPerDigit;
        this._digitsPerInt = aDigitsPerInt;
        this._digitsPerByte = aDigitsPerByte;
        this.intiCharToValueMap(aCharSet);
        this._paddingChar = aPaddingChar;
        this._bytesPerBlock = BaseMetricsImpl.toBytesPerBlock(aBitsPerDigit);
    }

    public BaseMetricsImpl(BaseMetrics aBaseMetrics) {
        this._bitsPerDigit = aBaseMetrics.getBitsPerDigit();
        this._bytesPerInt = aBaseMetrics.getBytesPerInt();
        this.intiCharToValueMap(aBaseMetrics.getCharSet());
        this._digitMask = aBaseMetrics.getDigitMask();
        this._digitsPerByte = aBaseMetrics.getDigitsPerByte();
        this._digitsPerInt = aBaseMetrics.getDigitsPerInt();
        this._numberBase = aBaseMetrics.getNumberBase();
        this._paddingChar = aBaseMetrics.getPaddingChar();
        this._bytesPerBlock = BaseMetricsImpl.toBytesPerBlock(aBaseMetrics.getBytesPerBlock());
    }

    private void intiCharToValueMap(char[] aCharSet) {
        int i = 0;
        while (i < aCharSet.length) {
            this._charToValueMap.put(Character.valueOf(aCharSet[i]), i);
            ++i;
        }
    }

    public int getNumberBase() {
        return this._numberBase;
    }

    @Override
    public char[] getCharSet() {
        return this._charSet;
    }

    @Override
    public int getBytesPerInt() {
        return this._bytesPerInt;
    }

    @Override
    public int getBytesPerBlock() {
        return this._bytesPerBlock;
    }

    @Override
    public int getDigitsPerInt() {
        return this._digitsPerInt;
    }

    @Override
    public int getBitsPerDigit() {
        return this._bitsPerDigit;
    }

    @Override
    public int getDigitsPerByte() {
        return this._digitsPerByte;
    }

    @Override
    public int getDigitMask() {
        return this._digitMask;
    }

    @Override
    public int toValue(char aChar) {
        if (aChar == this._paddingChar) {
            return 0;
        }
        Integer theValue = this._charToValueMap.get(Character.valueOf(aChar));
        if (theValue == null) {
            throw new IllegalArgumentException("The character '" + aChar + "' does not belong to the given <" + this.getNumberBase() + "> number base metrics with charset: " + VerboseTextBuilder.asString((char[])this.getCharSet()));
        }
        return theValue;
    }

    @Override
    public char toChar(int aValue) {
        return this._charSet[aValue];
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._bitsPerDigit;
        result = 31 * result + this._bytesPerBlock;
        result = 31 * result + this._bytesPerInt;
        result = 31 * result + Arrays.hashCode(this._charSet);
        result = 31 * result + (this._charToValueMap == null ? 0 : this._charToValueMap.hashCode());
        result = 31 * result + this._digitMask;
        result = 31 * result + this._digitsPerByte;
        result = 31 * result + this._digitsPerInt;
        result = 31 * result + this._numberBase;
        result = 31 * result + this._paddingChar;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseMetricsImpl other = (BaseMetricsImpl)obj;
        if (this._bitsPerDigit != other._bitsPerDigit) {
            return false;
        }
        if (this._bytesPerBlock != other._bytesPerBlock) {
            return false;
        }
        if (this._bytesPerInt != other._bytesPerInt) {
            return false;
        }
        if (!Arrays.equals(this._charSet, other._charSet)) {
            return false;
        }
        if (this._charToValueMap == null ? other._charToValueMap != null : !this._charToValueMap.equals(other._charToValueMap)) {
            return false;
        }
        if (this._digitMask != other._digitMask) {
            return false;
        }
        if (this._digitsPerByte != other._digitsPerByte) {
            return false;
        }
        if (this._digitsPerInt != other._digitsPerInt) {
            return false;
        }
        if (this._numberBase != other._numberBase) {
            return false;
        }
        return this._paddingChar == other._paddingChar;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [numberBase=" + this._numberBase + ", bytes/int=" + this._bytesPerInt + ", bits/digit=" + this._bitsPerDigit + ", digits/int=" + this._digitsPerInt + ", digits/byte=" + this._digitsPerByte + ", digitMask=" + this._digitMask + ", paddingChar='" + this._paddingChar + "', bytes/block=" + this._bytesPerBlock + "]";
    }

    protected static int toDigitMask(int aBitsPerDigit) {
        return (int)Math.pow(2.0, aBitsPerDigit) - 1;
    }

    protected static int toBitsPerDigit(int aBase) {
        int theBitsPerDigit = Integer.toBinaryString(aBase - 1).length();
        while (8 % theBitsPerDigit != 0 && 16 % theBitsPerDigit != 0 && 24 % theBitsPerDigit != 0 && 32 % theBitsPerDigit != 0) {
            ++theBitsPerDigit;
        }
        return theBitsPerDigit;
    }

    protected static int toDigitsPerInt(int aBytesPerInt, int aBitsPerDigit) {
        return 8 * aBytesPerInt / aBitsPerDigit;
    }

    protected static int toDigitsPerByte(int aBase) {
        int theDigitsPerByte = 0;
        int eMax = 1;
        while (eMax < 255) {
            ++theDigitsPerByte;
            eMax *= aBase;
        }
        return theDigitsPerByte;
    }

    protected static int toBytesPerInt(int aBitsPerDigit) {
        int i = 32;
        while (i > 0) {
            if (i % aBitsPerDigit == 0) {
                return i / 8;
            }
            --i;
        }
        i = 1;
        while (i <= aBitsPerDigit) {
            if (i * 8 % aBitsPerDigit == 0) {
                return i * 8 / 8;
            }
            ++i;
        }
        throw new BugException("We must have encountered a bug as we cannot determine the word length for a base codec with <" + aBitsPerDigit + "> bits per digit.");
    }

    protected static int toBytesPerBlock(int aBitsPerDigit) {
        int theBytesPerBlock = 1;
        while (theBytesPerBlock * 8 % aBitsPerDigit != 0) {
            ++theBytesPerBlock;
        }
        return theBytesPerBlock;
    }
}

