/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.refcodes.codec.ChannelSelector;
import org.refcodes.codec.DemodulatorStatus;
import org.refcodes.codec.ModemDecoder;
import org.refcodes.codec.ModemMetrics;
import org.refcodes.codec.ModulationFormat;
import org.refcodes.component.Openable;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.AbstractBytesReceiver;
import org.refcodes.io.BytesDestination;
import org.refcodes.io.BytesReceiver;
import org.refcodes.io.BytesReceiverDecorator;
import org.refcodes.io.ShortsDestination;
import org.refcodes.io.ShortsReceiver;
import org.refcodes.io.ShortsReceiverDecorator;

public class ModemDecoderImpl
extends AbstractBytesReceiver
implements ModemDecoder {
    private static final int DECODER_DATA_BUFFER_SIZE = 8;
    protected ModemMetrics _modemMetrics;
    protected LinkedBlockingQueue<Byte> _datagramQueue = new LinkedBlockingQueue(1024);
    protected BytesReceiver _byteReceiver;
    protected ShortsReceiver _shortReceiver;
    private DemodulatorStatus _decoderStatus = DemodulatorStatus.IDLE;
    private DemodulatorStatus _decoderPausedStatus = DemodulatorStatus.IDLE;
    private ShortBuffer _signalBuffer;
    private ShortBuffer _frameBuffer;
    private StringBuffer _bitBuffer;
    private int _currentBit = 0;
    private int _signalEnd = 0;
    private int _signalPointer = 0;
    private ByteBuffer _dataBuffer;
    private int _dataLength = 0;

    public ModemDecoderImpl(ModemMetrics aModemMetrics, BytesDestination aByteProvider) {
        this(aModemMetrics, (BytesReceiver)new BytesReceiverDecorator(aByteProvider));
    }

    public ModemDecoderImpl(ModemMetrics aModemMetrics, ShortsDestination aShortProvider) {
        this(aModemMetrics, (ShortsReceiver)new ShortsReceiverDecorator(aShortProvider));
    }

    public ModemDecoderImpl(ModemMetrics aModemMetrics, ShortsReceiver aShortReceiver) {
        this(aModemMetrics);
        this._shortReceiver = aShortReceiver;
    }

    public ModemDecoderImpl(ModemMetrics aModemMetrics, BytesReceiver aByteReceiver) {
        this(aModemMetrics);
        this._byteReceiver = aByteReceiver;
    }

    protected ModemDecoderImpl(ModemMetrics aModemMetrics) {
        this._modemMetrics = aModemMetrics;
        this._decoderStatus = this._decoderPausedStatus != DemodulatorStatus.IDLE ? this._decoderPausedStatus : DemodulatorStatus.SEARCHING_SIGNAL;
        this.initSignalBuffer();
        this.initFrameBuffer();
        this.initDataBuffer();
    }

    public byte[] receiveAllBytes() {
        return this.receiveBytes(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int available() {
        if (this._datagramQueue.size() <= 0) ** GOTO lbl20
        return this._datagramQueue.size();
lbl-1000:
        // 1 sources

        {
            var1_1 = this._signalBuffer;
            synchronized (var1_1) {
                this.doDecodeBuffer();
                switch (ModemDecoderImpl.$SWITCH_TABLE$org$refcodes$codec$DemodulatorStatus()[this._decoderStatus.ordinal()]) {
                    case 1: {
                        this.stop();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.doSearchCycle();
                        break;
                    }
                    case 4: {
                        this.doDecodeCycle();
                    }
                }
                continue;
            }
lbl20:
            // 2 sources

            ** while (this._decoderStatus != DemodulatorStatus.IDLE && this._datagramQueue.size() == 0)
        }
lbl21:
        // 1 sources

        return this._datagramQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] receiveBytes(int aMaxLength) {
        int size = aMaxLength;
        if (size == -1) {
            size = this._datagramQueue.size();
        }
        while (this._decoderStatus != DemodulatorStatus.IDLE && this._datagramQueue.size() < aMaxLength) {
            ShortBuffer shortBuffer = this._signalBuffer;
            synchronized (shortBuffer) {
                this.doDecodeBuffer();
                switch (this._decoderStatus) {
                    case IDLE: {
                        this.stop();
                        break;
                    }
                    case SEARCHING_SIGNAL: 
                    case SEARCHING_START_BIT: {
                        this.doSearchCycle();
                        break;
                    }
                    case DECODING: {
                        this.doDecodeCycle();
                    }
                }
            }
        }
        if (size > 0) {
            byte[] theData = new byte[size];
            int i = 0;
            while (i < theData.length) {
                try {
                    theData[i] = this._datagramQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            return theData;
        }
        throw new NoSuchElementException("No more elements of block size <" + size + "> in queue with size <" + this._datagramQueue.size() + ">!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte receiveByte() throws IOException {
        if (this._datagramQueue.size() <= 0) ** GOTO lbl23
        try {
            return this._datagramQueue.take();
        }
        catch (InterruptedException e) {
            throw new IOException("I/O operation has unexpectedly been interrupted upon receiving bytes!", e);
        }
lbl-1000:
        // 1 sources

        {
            e = this._signalBuffer;
            synchronized (e) {
                this.doDecodeBuffer();
                switch (ModemDecoderImpl.$SWITCH_TABLE$org$refcodes$codec$DemodulatorStatus()[this._decoderStatus.ordinal()]) {
                    case 1: {
                        this.stop();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.doSearchCycle();
                        break;
                    }
                    case 4: {
                        this.doDecodeCycle();
                    }
                }
                continue;
            }
lbl23:
            // 2 sources

            ** while (this._decoderStatus != DemodulatorStatus.IDLE && this._datagramQueue.size() == 0)
        }
lbl24:
        // 1 sources

        if (this._datagramQueue.size() > 0) {
            try {
                return this._datagramQueue.take();
            }
            catch (InterruptedException e) {
                throw new IOException("I/O operation has unexpectedly been interrupted upon receiving bytes!", e);
            }
        }
        throw new NoSuchElementException("No more elements in queue with size <" + this._datagramQueue.size() + ">!");
    }

    @Override
    public DemodulatorStatus getDemodulatorStatus() {
        return this._decoderStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDecodeBuffer() {
        ShortBuffer shortBuffer = this._signalBuffer;
        synchronized (shortBuffer) {
            int theBlockSize;
            short[] theData;
            block17: {
                theData = null;
                theBlockSize = this._signalBuffer.capacity() - this._signalEnd;
                if (theBlockSize > 0 || (theBlockSize = this._signalBuffer.capacity() - this._signalEnd + this._signalPointer) > 0) break block17;
                return 0;
            }
            if (theBlockSize > this._datagramQueue.remainingCapacity()) {
                theBlockSize = this._datagramQueue.remainingCapacity();
            }
            try {
                if (this._modemMetrics.getModulationFormat() == ModulationFormat.SHORT && this._shortReceiver != null && this._shortReceiver.hasAvailable()) {
                    theData = this._shortReceiver.receiveShorts(theBlockSize);
                }
            }
            catch (IOException e) {
                return 0;
            }
            short[] theMonoData = switch (this._modemMetrics.getChannelSelector()) {
                case ChannelSelector.MONO -> theData;
                case ChannelSelector.STEREO -> this.toMono(theData);
                default -> throw new IllegalStateException("The Modem-Metric's Channel-Selector is not set but must be set to one of the following: " + Arrays.toString((Object[])ChannelSelector.values()));
            };
            if (theMonoData != null) {
                if (this._signalEnd + theMonoData.length > this._signalBuffer.capacity()) {
                    if (this._signalEnd + theMonoData.length - this._signalPointer <= this._signalBuffer.capacity()) {
                        this.purge();
                    } else {
                        return this._signalBuffer.capacity() - (this._signalEnd + theMonoData.length);
                    }
                }
                this._signalBuffer.position(this._signalEnd);
                this._signalBuffer.put(theMonoData);
                this._signalEnd += theMonoData.length;
            }
            return this._signalBuffer.capacity() - this._signalEnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        ShortBuffer shortBuffer = this._signalBuffer;
        synchronized (shortBuffer) {
            this.initSignalBuffer();
            this._signalEnd = 0;
            this._signalPointer = 0;
            this._signalBuffer.capacity();
        }
    }

    private void purge() {
        if (this._signalPointer <= this._signalEnd) {
            short[] currentData = this._signalBuffer.array();
            short[] remainingData = new short[this._signalEnd - this._signalPointer];
            int i = 0;
            while (i < remainingData.length) {
                remainingData[i] = currentData[this._signalPointer + i];
                ++i;
            }
            this.initSignalBuffer();
            this._signalBuffer.put(remainingData);
            this._signalBuffer.rewind();
            this._signalPointer = 0;
            this._signalEnd = remainingData.length;
        } else {
            this.clear();
        }
    }

    private short[] getFrame(int aIndex) {
        this._signalBuffer.position(aIndex);
        this.initFrameBuffer();
        int j = 0;
        while (j < this._modemMetrics.toSamplesPerBit()) {
            this._frameBuffer.put(j, this._signalBuffer.get());
            ++j;
        }
        return this._frameBuffer.array();
    }

    private void flush() {
        if (this._dataLength > 0) {
            byte[] data = new byte[this._dataLength];
            int i = 0;
            while (i < this._dataLength) {
                data[i] = this._dataBuffer.get(i);
                ++i;
            }
            this.initDataBuffer();
            this._dataLength = 0;
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte eData = byArray[n2];
                try {
                    this._datagramQueue.offer(eData, SleepLoopTime.MAX.getTimeMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private void doSearchCycle() {
        if (this._signalPointer <= this._signalEnd - this._modemMetrics.toSamplesPerBit()) {
            short[] frameData = this.getFrame(this._signalPointer);
            int freq = this.toFrequencyZeroCrossing(frameData);
            SignalStatus state = this.toState(freq, this.toRootMeanSquared(frameData));
            if (state == SignalStatus.HIGH && this._decoderStatus == DemodulatorStatus.SEARCHING_SIGNAL) {
                this.nextStatus();
            }
            if (this._decoderStatus == DemodulatorStatus.SEARCHING_START_BIT && freq == this._modemMetrics.getModemMode().getLowerFrequency() && state == SignalStatus.LOW) {
                this._signalPointer += this._modemMetrics.toSamplesPerBit() / 2;
                this.nextStatus();
                return;
            }
            ++this._signalPointer;
        } else {
            this.purge();
            this.flush();
            this._decoderStatus = DemodulatorStatus.IDLE;
        }
    }

    private void doDecodeCycle() {
        if (this._signalPointer <= this._signalEnd - this._modemMetrics.toSamplesPerBit()) {
            short[] frameData = this.getFrame(this._signalPointer);
            double rms = this.toRootMeanSquared(frameData);
            int freq = this.toFrequencyZeroCrossing(frameData);
            SignalStatus state = this.toState(freq, rms);
            if (this._currentBit == 0 && state == SignalStatus.LOW) {
                this._bitBuffer = new StringBuffer();
                ++this._currentBit;
            } else if (this._currentBit == 0 && state == SignalStatus.HIGH) {
                this._decoderStatus = DemodulatorStatus.SEARCHING_START_BIT;
            } else if (this._currentBit == 9 && state == SignalStatus.HIGH) {
                try {
                    this._dataBuffer.put((byte)Integer.parseInt(this._bitBuffer.toString(), 2));
                    ++this._dataLength;
                    if (this._dataLength == this._dataBuffer.capacity()) {
                        this.flush();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this._currentBit = 0;
            } else if (this._currentBit > 0 && this._currentBit < 9 && (state == SignalStatus.HIGH || state == SignalStatus.LOW)) {
                this._bitBuffer.insert(0, state.equals((Object)SignalStatus.HIGH) ? 1 : 0);
                ++this._currentBit;
            } else {
                this._bitBuffer = new StringBuffer();
                this._currentBit = 0;
                this._decoderStatus = DemodulatorStatus.SEARCHING_START_BIT;
            }
            this._signalPointer += this._modemMetrics.toSamplesPerBit();
        } else {
            this.purge();
            this.flush();
            this._decoderStatus = DemodulatorStatus.IDLE;
            this._decoderPausedStatus = DemodulatorStatus.DECODING;
        }
    }

    private void initSignalBuffer() {
        this._signalBuffer = ShortBuffer.allocate(this._modemMetrics.getSampleRate().getValue());
    }

    private void initFrameBuffer() {
        this._frameBuffer = ShortBuffer.allocate(this._modemMetrics.toSamplesPerBit());
    }

    private void initDataBuffer() {
        this._dataBuffer = ByteBuffer.allocate(8);
    }

    private void stop() {
    }

    private void nextStatus() {
        switch (this._decoderStatus) {
            case IDLE: {
                this._decoderStatus = DemodulatorStatus.SEARCHING_SIGNAL;
                break;
            }
            case SEARCHING_SIGNAL: {
                this._decoderStatus = DemodulatorStatus.SEARCHING_START_BIT;
                break;
            }
            case SEARCHING_START_BIT: {
                this._decoderStatus = DemodulatorStatus.DECODING;
                break;
            }
            case DECODING: {
                this._decoderStatus = DemodulatorStatus.IDLE;
            }
        }
    }

    private short[] toMono(short[] aData) {
        short[] theMonoData = new short[aData.length / 2];
        int i = 0;
        while (i < aData.length - 1) {
            int theAverage = (aData[i] + aData[i + 1]) / 2;
            theMonoData[i / 2] = (short)theAverage;
            i += 2;
        }
        return theMonoData;
    }

    private int toFrequencyZeroCrossing(short[] aData) {
        int theSamples = aData.length;
        int theCrossing = 0;
        int i = 0;
        while (i < theSamples - 1) {
            if (aData[i] > 0 && aData[i + 1] <= 0 || aData[i] < 0 && aData[i + 1] >= 0) {
                ++theCrossing;
            }
            ++i;
        }
        double theSecondsRecorded = (double)theSamples / (double)this._modemMetrics.getSampleRate().getValue().intValue();
        double theCycles = theCrossing / 2;
        double theFrequency = theCycles / theSecondsRecorded;
        return (int)Math.round(theFrequency);
    }

    private double toRootMeanSquared(short[] aData) {
        double theMillisecs = 0.0;
        short[] sArray = aData;
        int n = aData.length;
        int n2 = 0;
        while (n2 < n) {
            short anAData = sArray[n2];
            theMillisecs += (double)(anAData * anAData);
            ++n2;
        }
        return Math.sqrt(theMillisecs /= (double)aData.length);
    }

    private SignalStatus toState(int frequency, double rms) {
        SignalStatus state = SignalStatus.UNKNOWN;
        if (rms <= (double)this._modemMetrics.getModulationFormat().getSilenceThreshold()) {
            state = SignalStatus.SILENCE;
        } else if (frequency <= this._modemMetrics.toLowerFrequencyUpperThreshold()) {
            state = SignalStatus.LOW;
        } else if (frequency <= this._modemMetrics.toHigherFrequencyUpperThreshold()) {
            state = SignalStatus.HIGH;
        }
        return state;
    }

    public static class ModemByteDecoderProviderImpl
    extends ModemDecoderImpl
    implements ModemDecoder.ModemByteDecoderProvider {
        public ModemByteDecoderProviderImpl(ModemMetrics aModemMetrics) {
            super(aModemMetrics);
        }

        public void open(BytesDestination aConnection) throws IOException {
            if (this._modemMetrics.getModulationFormat() != ModulationFormat.BYTE) {
                throw new IllegalArgumentException("When configuring a modulation format other than <" + (Object)((Object)ModulationFormat.BYTE) + ">, then you must not pass a Byte-DatagramsDestination.");
            }
            this._byteReceiver = aConnection instanceof BytesReceiver ? (BytesReceiver)aConnection : new BytesReceiverDecorator(aConnection);
            if (!this._byteReceiver.isOpened()) {
                if (this._byteReceiver instanceof Openable) {
                    ((Openable)this._byteReceiver).open();
                } else {
                    throw new IOException("The provided connection is in status <" + this._byteReceiver.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
                }
            }
            this.open();
        }
    }

    public static class ModemShortDecoderProviderImpl
    extends ModemDecoderImpl
    implements ModemDecoder.ModemShortDecoderProvider {
        public ModemShortDecoderProviderImpl(ModemMetrics aModemMetrics) {
            super(aModemMetrics);
        }

        public void open(ShortsDestination aConnection) throws IOException {
            if (this._modemMetrics.getModulationFormat() != ModulationFormat.SHORT) {
                throw new IllegalArgumentException("When configuring a modulation format other than <" + (Object)((Object)ModulationFormat.SHORT) + ">, then you must not pass a Short-DatagramsDestination.");
            }
            this._shortReceiver = aConnection instanceof ShortsReceiver ? (ShortsReceiver)aConnection : new ShortsReceiverDecorator(aConnection);
            if (!this._shortReceiver.isOpened()) {
                if (this._shortReceiver instanceof Openable) {
                    ((Openable)this._shortReceiver).open();
                } else {
                    throw new IOException("The provided connection is in status <" + this._shortReceiver.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
                }
            }
            this.open();
        }
    }

    private static enum SignalStatus {
        HIGH,
        LOW,
        SILENCE,
        UNKNOWN;

    }
}

