/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.data.Delimiter;
import org.refcodes.data.FileNameExtension;
import org.refcodes.data.Port;
import org.refcodes.data.Suffix;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.PortAccessor;

public enum Scheme implements NameAccessor,
PortAccessor
{
    JAR("jar", "", FileNameExtension.JAR.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    ZIP("zip", "", FileNameExtension.ZIP.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    SH("sh", "", FileNameExtension.SH.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    FILE("file", "", "file" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar()),
    HTTP("http", "" + Delimiter.PATH.getChar() + Delimiter.PATH.getChar(), Port.HTTP.getPort()),
    HTTPS("https", "" + Delimiter.PATH.getChar() + Delimiter.PATH.getChar(), Port.HTTPS.getPort()),
    SOCKS("socks", "" + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    SOCKS4("socks4", "" + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    SOCKS5("socks4", "" + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    UNKNOWN("???", "");

    private String _name;
    private String _specific;
    private String _marker;
    private int _port = -1;

    private Scheme(String aName, String aSpecific) {
        this._name = aName;
        this._specific = aSpecific;
        this._marker = aName + Suffix.PROTOCOL.getSuffix() + this._specific;
    }

    private Scheme(String aName, String aSpecific, int aPort) {
        this._name = aName;
        this._specific = aSpecific;
        this._marker = aName + Suffix.PROTOCOL.getSuffix() + this._specific;
        this._port = aPort;
    }

    private Scheme(String aName, String aSpecific, String aMarker) {
        this._name = aName;
        this._specific = aSpecific;
        this._marker = aMarker;
    }

    public String getName() {
        return this._name;
    }

    public String getSpecific() {
        return this._specific;
    }

    public String toProtocol() {
        return this._name + Suffix.PROTOCOL.getSuffix() + this._specific;
    }

    public String toUrl(String aUrl, int aBeginIndex) {
        String theLocator = aUrl;
        int i = theLocator.indexOf(this._marker, aBeginIndex);
        if (i != -1) {
            return theLocator.substring(0, i += this._marker.length() - 1);
        }
        return null;
    }

    public String toUrl(String aUrl) {
        return this.toUrl(aUrl, 0);
    }

    public int nextMarkerIndex(String aUrl, int aBeginIndex) {
        int i = aUrl.indexOf(this._marker, aBeginIndex);
        if (i != -1) {
            i += this._marker.length() - 1;
        }
        return i;
    }

    public int firstMarkerIndex(String aUrl) {
        int i = aUrl.indexOf(this._marker, 0);
        if (i != -1) {
            i += this._marker.length() - 1;
        }
        return i;
    }

    public String getMarker() {
        return this._marker;
    }

    public int getPort() {
        return this._port;
    }

    public static Scheme fromName(String aName) {
        if (aName != null) {
            for (Scheme eElement : Scheme.values()) {
                if (!eElement.getName().equalsIgnoreCase(aName)) continue;
                return eElement;
            }
        }
        return null;
    }

    public static Scheme fromProtocol(String aProtocol) {
        if (aProtocol != null) {
            for (Scheme eElement : Scheme.values()) {
                if (!eElement.toProtocol().toLowerCase().startsWith(aProtocol.toLowerCase())) continue;
                return eElement;
            }
        }
        return null;
    }

    public static Scheme fromScheme(String aUrl) {
        if (aUrl != null) {
            for (Scheme eElement : Scheme.values()) {
                if (!aUrl.toLowerCase().startsWith(eElement.toProtocol().toLowerCase())) continue;
                return eElement;
            }
        }
        return null;
    }
}

