/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.data.Delimiter;
import org.refcodes.mixin.CodeAccessor;

public enum AnsiEscapeCode implements CodeAccessor<Byte>
{
    RESET(0),
    BOLD(1),
    FAINT(2),
    ITALIC(3),
    UNDERLINE(4),
    SLOW_BLINK(5),
    RAPID_BLINK(6),
    REVERSE_VIDEO(7),
    CONCEAL(8),
    CROSSED_OUT(9),
    DEFAULT_FONT(10),
    FONT_1(11),
    FONT_2(12),
    FONT_3(13),
    FONT_4(14),
    FONT_5(15),
    FONT_6(16),
    FONT_7(17),
    FONT_8(18),
    FONT_9(19),
    FRAKTUR(20),
    DOUBLY_UNDERLINE_OR_BOLD_OFF(21),
    NORMAL_COLOR_OR_INTENSITY(22),
    NOT_ITALIC_NOT_FRAKTUR(23),
    UNDERLINE_OFF(24),
    BLINK_OFF(25),
    INVERSE_OFF(27),
    REVEAL(28),
    NOT_CROSSED_OUT(29),
    FG_BLACK(30),
    FG_RED(31),
    FG_GREEN(32),
    FG_YELLOW(33),
    FG_BLUE(34),
    FG_MAGENTA(35),
    FG_CYAN(36),
    FG_WHITE(37),
    SET_FOREGROUND_COLOR(38),
    DEFAULT_FOREGROUND_COLOR(39),
    BG_BLACK(40),
    BG_RED(41),
    BG_GREEN(42),
    BG_YELLOW(43),
    BG_BLUE(44),
    BG_MAGENTA(45),
    BG_CYAN(46),
    BG_WHITE(47),
    SET_BACKGROUND_COLOR(48),
    DEFAULT_BACKGROUND_COLOR(49),
    FRAMED(51),
    ENCIRCLED(52),
    OVERLINED(53),
    NOT_FRAMED(54),
    NOT_OVERLINED(55),
    IDEOGRAM_UNDERLINE_OR_RIGHT_SIDE_LINE(60),
    IDEOGRAM_DOUBLE_UNDERLINE_OR_DOUBLE_LINE_ON_THE_RIGHT_SIDE(61),
    IDEOGRAM_OVERLINE_OR_LEFT_SIDE_LINE(62),
    IDEOGRAM_DOUBLE_OVERLINE_OR_DOUBLE_LINE_ON_THE_LEFT_SIDE(63),
    IDEOGRAM_STRESS_MARKING(64),
    IDEOGRAM_ATTRIBUTES_OFF(65),
    FG_BRIGHT_BLACK(90),
    FG_BRIGHT_RED(91),
    FG_BRIGHT_GREEN(92),
    FG_BRIGHT_YELLOW(93),
    FG_BRIGHT_BLUE(94),
    FG_BRIGHT_MAGENTA(95),
    FG_BRIGHT_CYAN(96),
    FG_BRIGHT_WHITE(97),
    FG_BRIGHT_DEFAULT(99),
    BG_BRIGHT_BLACK(100),
    BG_BRIGHT_RED(101),
    BG_BRIGHT_GREEN(102),
    BG_BRIGHT_YELLOW(103),
    BG_BRIGHT_BLUE(104),
    BG_BRIGHT_MAGENTA(105),
    BG_BRIGHT_CYAN(106),
    BG_BRIGHT_WHITE(107),
    BG_BRIGHT_DEFAULT(109);

    public static char ESCAPE;
    public static char ESCAPE_SUFFIX;
    public static char ESCAPE_PARAMETER_DELIMITER;
    public static char ESCAPE_PREFIX_DELIMITER;
    public static char RGB_COLOR_SELECTOR_PARAMETER;
    public static char COLOR_TABLE_SELECTOR_PARAMETER;
    private byte _ansiEscapeCode;

    private AnsiEscapeCode(byte aAnsiEscapeCode) {
        this._ansiEscapeCode = aAnsiEscapeCode;
    }

    public Byte getCode() {
        return this._ansiEscapeCode;
    }

    public String toEscaped() {
        return (this._ansiEscapeCode + "").replaceAll(ESCAPE + "", "\\u001B");
    }

    public static String toEscapeSequence(AnsiEscapeCode ... aAnsiEscapeCodes) {
        int n = 0;
        StringBuffer theSequence = new StringBuffer();
        theSequence.append(ESCAPE);
        theSequence.append(ESCAPE_PREFIX_DELIMITER);
        for (int i = 0; i < aAnsiEscapeCodes.length; ++i) {
            AnsiEscapeCode eCode = aAnsiEscapeCodes[i];
            theSequence.append(eCode.getCode());
            if (eCode == SET_FOREGROUND_COLOR || eCode == SET_BACKGROUND_COLOR) {
                AnsiEscapeCode.appendColorTableIndex(n, theSequence);
                ++n;
            }
            if (i >= aAnsiEscapeCodes.length - 1) continue;
            theSequence.append(ESCAPE_PARAMETER_DELIMITER);
        }
        theSequence.append(ESCAPE_SUFFIX);
        return theSequence.toString();
    }

    public static String toEscapedSequence(String aEscapeSequence) {
        return aEscapeSequence.replaceAll(ESCAPE + "", "\\u001B");
    }

    private static void appendColorTableIndex(int aColorPaletteIndex, StringBuffer aSequence) {
        aSequence.append(ESCAPE_PARAMETER_DELIMITER);
        aSequence.append(COLOR_TABLE_SELECTOR_PARAMETER);
        aSequence.append(ESCAPE_PARAMETER_DELIMITER);
        aSequence.append("${n");
        aSequence.append(aColorPaletteIndex);
        aSequence.append("}");
    }

    static {
        ESCAPE = (char)27;
        ESCAPE_SUFFIX = (char)109;
        ESCAPE_PARAMETER_DELIMITER = Delimiter.ANSI_ESCAPE_PARAMETER.getChar();
        ESCAPE_PREFIX_DELIMITER = Delimiter.ANSI_ESCAPE_PREFIX.getChar();
        RGB_COLOR_SELECTOR_PARAMETER = (char)2;
        COLOR_TABLE_SELECTOR_PARAMETER = (char)5;
    }
}

