/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.junit.jupiter.api.Test;
import org.refcodes.data.FilenameExtension;

public class FilenameExtensionTest {
    private static final boolean IS_LOG_TESTS_ENABLED = Boolean.getBoolean("log.tests");
    private static final String[] FILES = new String[]{".hallo", "hallo", "hallo.txt", "hallo.tar.gz", "hallo.png", "hallo.chaos64", "/hallo", "./hallo.txt", "~/temp/hallo.tar.gz", "/mnt/transfer/hallo.png", "C:\\Users\\5161\\hallo.chaos64", ".hallo.", "./hallo/du/da/hallo."};

    @Test
    public void testRawFileNameExtension() {
        for (String eFilename : FILES) {
            if (!IS_LOG_TESTS_ENABLED) continue;
            String eExtension = FilenameExtension.toRawFileNameExtension((String)eFilename);
            System.out.println(eExtension + " <-- " + eFilename);
        }
    }

    @Test
    public void testFileNameExtension() {
        for (String eFilename : FILES) {
            if (!IS_LOG_TESTS_ENABLED) continue;
            FilenameExtension eExtension = FilenameExtension.toFileNameExtension((String)eFilename);
            System.out.println(eExtension + " <-- " + eFilename);
        }
    }
}

