/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Scheme;

public class SchemeTest {
    private static final boolean IS_LOG_TESTS_ENABLED = Boolean.getBoolean("log.tests");
    private static final String[][] RESULTS = new String[][]{{"jar", "jar:", ".jar!"}, {"zip", "zip:", ".zip!"}, {"sh", "sh:", ".sh!"}, {"file", "file:", "file:/"}, {"http", "http://", "http://"}, {"https", "https://", "https://"}, {"socks", "socks://", "socks://"}, {"socks4", "socks4://", "socks4://"}, {"socks5", "socks5://", "socks5://"}, {"???", "???:", "???:"}};
    private static Map<Scheme, String[]> SCHEMES;

    @BeforeAll
    public static void beforeAll() {
        SCHEMES = new HashMap<Scheme, String[]>();
        for (String[] aRESULTS : RESULTS) {
            Scheme eScheme = Scheme.fromName((String)aRESULTS[0]);
            SCHEMES.put(eScheme, aRESULTS);
        }
    }

    @Test
    public void testScheme() {
        for (Scheme eScheme : Scheme.values()) {
            if (IS_LOG_TESTS_ENABLED) {
                System.out.println(eScheme.getName() + ", " + eScheme.toProtocol() + ", " + eScheme.getMarker());
            }
            String[] eExpected = SCHEMES.get(eScheme);
            Assertions.assertEquals((Object)eExpected[0], (Object)eScheme.getName());
            Assertions.assertEquals((Object)eExpected[1], (Object)eScheme.toProtocol());
            Assertions.assertEquals((Object)eExpected[2], (Object)eScheme.getMarker());
        }
    }
}

