/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.gateway.starter.config;

import org.apache.commons.lang3.StringUtils;
import org.rxjava.common.core.entity.LoginInfo;
import org.rxjava.common.core.exception.LoginRuntimeException;
import org.rxjava.common.core.service.DefaultLoginInfoServiceImpl;
import org.rxjava.common.core.service.LoginInfoService;
import org.rxjava.gateway.starter.config.AuthenticationToken;
import org.rxjava.gateway.starter.config.CustomServerAuthenticationSuccessHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@EnableWebFluxSecurity
public class RxJavaWebFluxSecurityConfig {
    @Bean
    @ConditionalOnMissingBean
    public LoginInfoService loginInfoService() {
        return new DefaultLoginInfoServiceImpl();
    }

    @Bean
    public ReactiveAuthenticationManager reactiveAuthenticationManager(LoginInfoService loginInfoService) {
        return authentication -> {
            AuthenticationToken authenticationToken = (AuthenticationToken)authentication;
            String token = authenticationToken.getToken();
            return loginInfoService.checkToken(token).switchIfEmpty(LoginRuntimeException.mono((String)"401 unauthorized")).map(loginInfo -> new AuthenticationToken(authenticationToken.getToken(), (LoginInfo)loginInfo));
        };
    }

    @Bean
    public AuthenticationWebFilter authenticationFilter(ReactiveAuthenticationManager reactiveAuthenticationManager) {
        AuthenticationWebFilter filter = new AuthenticationWebFilter(reactiveAuthenticationManager);
        filter.setServerAuthenticationConverter(this::authenticationConverter);
        filter.setAuthenticationFailureHandler((exchange, exception) -> LoginRuntimeException.mono((String)"401 unauthorized"));
        filter.setAuthenticationSuccessHandler((ServerAuthenticationSuccessHandler)new CustomServerAuthenticationSuccessHandler());
        return filter;
    }

    private Mono<Authentication> authenticationConverter(ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        String authorization = request.getHeaders().getFirst("Authorization");
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            return Mono.empty();
        }
        return Mono.just((Object)((Object)new AuthenticationToken(authorization)));
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http, AuthenticationWebFilter authenticationFilter) {
        return ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(new String[]{"/**"})).permitAll().anyExchange().authenticated().and().securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance()).exceptionHandling().authenticationEntryPoint((exchange, e) -> Mono.fromRunnable(() -> exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED))).accessDeniedHandler((exchange, e) -> Mono.fromRunnable(() -> exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN))).and().csrf().disable().formLogin().disable().logout().disable().addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION).build();
    }
}

