/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.gateway.starter.config;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.rxjava.common.core.entity.LoginInfo;
import org.rxjava.common.core.utils.JsonUtils;
import org.rxjava.gateway.starter.config.AuthenticationToken;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CustomServerAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        WebFilterChain chain = webFilterExchange.getChain();
        ServerHttpRequest request = exchange.getRequest();
        AuthenticationToken authenticationToken = (AuthenticationToken)authentication;
        LoginInfo loginInfo = authenticationToken.getLoginInfo();
        if (ObjectUtils.isEmpty((Object)loginInfo)) {
            return chain.filter(exchange);
        }
        String loginInfoJson = null;
        try {
            loginInfoJson = URLEncoder.encode(JsonUtils.serialize((Object)loginInfo), "utf8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)loginInfoJson)) {
            return chain.filter(exchange);
        }
        ServerHttpRequest host = request.mutate().header("loginInfo", loginInfoJson).build();
        ServerWebExchange build = exchange.mutate().request(host).build();
        return chain.filter(build);
    }
}

