/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.behaviors.picking.PickMouseBehavior;
import com.sun.j3d.utils.behaviors.picking.PickingCallback;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public class PickZoomBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    MouseZoom zoom = new MouseZoom(1);
    int pickMode = 512;
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.zoom.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public PickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.zoom.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.pickMode = pickMode;
    }

    public void setPickMode(int pickMode) {
        this.pickMode = pickMode;
    }

    public int getPickMode() {
        return this.pickMode;
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (this.mevent.isAltDown() && !this.mevent.isMetaDown()) {
            tg = (TransformGroup)this.pickScene.pickNode(this.pickScene.pickClosest(xpos, ypos, this.pickMode), 32);
            if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
                this.zoom.setTransformGroup(tg);
                this.zoom.wakeup();
                this.currentTG = tg;
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(2, this.currentTG);
    }

    public void setupCallback(PickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.zoom.setupCallback(null);
        } else {
            this.zoom.setupCallback(this);
        }
    }
}

