/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking.behaviors;

import com.sun.j3d.utils.picking.PickCanvas;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;

public abstract class PickMouseBehavior
extends Behavior {
    protected PickCanvas pickCanvas;
    protected WakeupCriterion[] conditions;
    protected WakeupOr wakeupCondition;
    protected boolean buttonPress = false;
    protected TransformGroup currGrp = new TransformGroup();
    protected static final boolean debug = false;
    protected MouseEvent mevent;

    public PickMouseBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        this.currGrp.setCapability(18);
        this.currGrp.setCapability(17);
        root.addChild((Node)this.currGrp);
        this.pickCanvas = new PickCanvas(canvas, root);
    }

    public void setMode(int pickMode) {
        this.pickCanvas.setMode(pickMode);
    }

    public int getMode() {
        return this.pickCanvas.getMode();
    }

    public void setTolerance(float tolerance) {
        this.pickCanvas.setTolerance(tolerance);
    }

    public float getTolerance() {
        return this.pickCanvas.getTolerance();
    }

    public void initialize() {
        this.conditions = new WakeupCriterion[2];
        this.conditions[0] = new WakeupOnAWTEvent(503);
        this.conditions[1] = new WakeupOnAWTEvent(501);
        this.wakeupCondition = new WakeupOr(this.conditions);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        if (evt.getID() == 501 | evt.getID() == 500) {
            this.buttonPress = true;
            return;
        }
        if (evt.getID() == 503) {
            // empty if block
        }
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xpos = this.mevent.getPoint().x;
            ypos = this.mevent.getPoint().y;
        }
        if (this.buttonPress) {
            this.updateScene(xpos, ypos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public abstract void updateScene(int var1, int var2);
}

