/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry.PrimitiveState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.SceneGraphObject;

public class BoxState
extends PrimitiveState {
    private float xdim;
    private float ydim;
    private float zdim;
    private int frontAppearance;
    private int backAppearance;
    private int topAppearance;
    private int bottomAppearance;
    private int leftAppearance;
    private int rightAppearance;

    public BoxState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.frontAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(0).getAppearance());
            this.backAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(1).getAppearance());
            this.topAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(4).getAppearance());
            this.bottomAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(5).getAppearance());
            this.leftAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(3).getAppearance());
            this.rightAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Box)this.node).getShape(2).getAppearance());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.frontAppearance);
        out.writeInt(this.backAppearance);
        out.writeInt(this.topAppearance);
        out.writeInt(this.bottomAppearance);
        out.writeInt(this.leftAppearance);
        out.writeInt(this.rightAppearance);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.frontAppearance = in.readInt();
        this.backAppearance = in.readInt();
        this.topAppearance = in.readInt();
        this.bottomAppearance = in.readInt();
        this.leftAppearance = in.readInt();
        this.rightAppearance = in.readInt();
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeFloat(((Box)this.node).getXdimension());
        out.writeFloat(((Box)this.node).getYdimension());
        out.writeFloat(((Box)this.node).getZdimension());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.xdim = in.readFloat();
        this.ydim = in.readFloat();
        this.zdim = in.readFloat();
    }

    @Override
    public void buildGraph() {
        if (this.frontAppearance == this.backAppearance && this.frontAppearance == this.topAppearance && this.frontAppearance == this.bottomAppearance && this.frontAppearance == this.leftAppearance && this.frontAppearance == this.rightAppearance) {
            ((Box)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.frontAppearance));
        } else {
            ((Box)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.frontAppearance));
            ((Box)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.backAppearance));
            ((Box)this.node).setAppearance(4, (Appearance)this.control.getSymbolTable().getJ3dNode(this.topAppearance));
            ((Box)this.node).setAppearance(5, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bottomAppearance));
            ((Box)this.node).setAppearance(3, (Appearance)this.control.getSymbolTable().getJ3dNode(this.leftAppearance));
            ((Box)this.node).setAppearance(2, (Appearance)this.control.getSymbolTable().getJ3dNode(this.rightAppearance));
        }
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Box box = (Box)super.createNode(j3dClass, new Class[]{Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.xdim), new Float(this.ydim), new Float(this.zdim), new Integer(this.primflags), null});
        return box;
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Box(this.xdim, this.ydim, this.zdim, this.primflags, null);
    }
}

