/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.audioengines;

public class AudioEngineThread
extends Thread {
    protected static final boolean debugFlag = false;
    protected static final int WORK_THREAD = 1;
    protected static final int UPDATE_THREAD = 2;
    protected static final int WAIT = 0;
    protected static final int NOTIFY_AND_WAIT = 1;
    protected static final int RUN = 2;
    protected static final int STOP = 3;
    protected boolean active = false;
    protected boolean running = true;
    protected boolean started = false;
    protected long referenceTime;
    protected long lastWaitTimestamp = 0L;
    protected int type;
    protected int classification = 1;
    protected Object[] args = null;
    protected boolean userStop = false;
    protected boolean waiting = false;
    protected static int numInstances = 0;
    protected int instanceNum = -1;

    protected void debugPrint(String message) {
    }

    public AudioEngineThread(ThreadGroup t, String threadName) {
        super(t, threadName);
    }

    synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    public synchronized void doWork() {
    }

    public void initialize() {
        this.start();
        while (!this.started) {
            try {
                Thread.currentThread();
                Thread.sleep(1L, 0);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void finish() {
        while (!this.waiting) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runMonitor(3, 0L, null);
    }

    @Override
    public void run() {
        this.runMonitor(0, 0L, null);
        while (this.running) {
            this.doWork();
            this.runMonitor(0, 0L, null);
        }
        this.shutdown();
    }

    public synchronized void runMonitor(int action, long referenceTime, Object[] args) {
        switch (action) {
            case 0: {
                try {
                    this.started = true;
                    this.waiting = true;
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                }
                this.waiting = false;
                break;
            }
            case 2: {
                this.referenceTime = referenceTime;
                this.args = args;
                this.notify();
                break;
            }
            case 3: {
                this.running = false;
                this.notify();
            }
        }
    }

    public void shutdown() {
    }

    public void cleanup() {
        this.active = false;
        this.running = true;
        this.started = true;
        this.lastWaitTimestamp = 0L;
        this.classification = 1;
        this.args = null;
        this.userStop = false;
        this.referenceTime = 0L;
    }
}

