/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.scijava.java3d.J3DBuffer;
import org.scijava.java3d.internal.BufferWrapper;
import org.scijava.java3d.internal.DoubleBufferWrapper;
import org.scijava.java3d.internal.FloatBufferWrapper;

public class ByteBufferWrapper
extends BufferWrapper {
    private ByteBuffer buffer = null;

    public ByteBufferWrapper(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferWrapper(J3DBuffer b) {
        this.buffer = (ByteBuffer)b.getBuffer();
    }

    public static ByteBufferWrapper allocateDirect(int capacity) {
        ByteBuffer bb = ByteBuffer.allocateDirect(capacity);
        return new ByteBufferWrapper(bb);
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public ByteBufferWrapper get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    public ByteBufferWrapper get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBufferWrapper order(ByteOrder bo) {
        this.buffer.order(bo);
        return this;
    }

    public FloatBufferWrapper asFloatBuffer() {
        return new FloatBufferWrapper(this.buffer.asFloatBuffer());
    }

    public DoubleBufferWrapper asDoubleBuffer() {
        return new DoubleBufferWrapper(this.buffer.asDoubleBuffer());
    }

    public ByteBufferWrapper put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    public J3DBuffer getJ3DBuffer() {
        return new J3DBuffer((Buffer)this.buffer);
    }
}

