/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Node;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.internal.J3dUtilsI18N;
import org.scijava.java3d.loaders.IncorrectFormatException;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.LwsFrame;
import org.scijava.java3d.loaders.lw3d.TextfileParser;
import org.scijava.java3d.utils.behaviors.interpolators.KBKeyFrame;
import org.scijava.java3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Quat4f;

class LwsMotion
extends TextfileParser {
    String motionName;
    LwsFrame[] frames;
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int firstFrame;
    int totalFrames;
    Behavior behaviors;

    LwsMotion(StreamTokenizer st, int frames, float time) {
        this(st, 0, frames, time, 16);
    }

    LwsMotion(StreamTokenizer st, int firstFrame, int frames, float time, int debugVals) throws ParsingErrorException, IncorrectFormatException {
        this.debugPrinter.setValidOutput(debugVals);
        this.numFrames = 0;
        this.totalTime = time;
        this.firstFrame = firstFrame;
        this.totalFrames = frames;
        this.debugOutputLn(8, "about to get motion name");
        this.motionName = this.getName(st);
        this.debugOutputLn(8, "about to get motion");
        this.getMotion(st);
    }

    void getMotion(StreamTokenizer st) throws ParsingErrorException, IncorrectFormatException {
        this.debugOutputLn(1, "getMotion()");
        this.numChannels = (int)this.getNumber(st);
        if (this.numChannels != 9) {
            throw new IncorrectFormatException(J3dUtilsI18N.getString("LwsMotion0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(st);
        this.frames = new LwsFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        for (int i = 0; i < this.numFrames; ++i) {
            this.frames[i] = new LwsFrame(st);
        }
        this.debugOutput(8, "got all frames");
        this.getAndCheckString(st, "EndBehavior");
        int repeatVal = (int)this.getNumber(st);
        this.loop = repeatVal != 1;
    }

    void fixFrames() {
        boolean addedFrames = false;
        Vector<LwsFrame> newFramesList = new Vector<LwsFrame>();
        double halfPI = 1.5707963705062866;
        LwsFrame finalFrame = null;
        for (int i = 1; i < this.numFrames; ++i) {
            double adj1;
            LwsFrame nextFrame;
            double adj0;
            LwsFrame prevFrame;
            double increment;
            LwsFrame thisFrame;
            LwsFrame lastFrame = this.frames[i - 1];
            finalFrame = thisFrame = this.frames[i];
            newFramesList.add(lastFrame);
            double largestAngleDifference = 0.0;
            double thisAngle = thisFrame.getHeading();
            double lastAngle = lastFrame.getHeading();
            double angleDifference = Math.abs(thisAngle - lastAngle);
            if (angleDifference > largestAngleDifference) {
                largestAngleDifference = angleDifference;
            }
            if ((angleDifference = Math.abs((thisAngle = thisFrame.getPitch()) - (lastAngle = lastFrame.getPitch()))) > largestAngleDifference) {
                largestAngleDifference = angleDifference;
            }
            if ((angleDifference = Math.abs((thisAngle = thisFrame.getBank()) - (lastAngle = lastFrame.getBank()))) > largestAngleDifference) {
                largestAngleDifference = angleDifference;
            }
            if (!(largestAngleDifference > halfPI)) continue;
            addedFrames = true;
            int numNewFrames = (int)(largestAngleDifference / halfPI);
            double currentRatio = increment = 1.0 / (double)(numNewFrames + 1);
            double totalf = this.frames[this.numFrames - 1].getFrameNum();
            double tlength = (thisFrame.getFrameNum() - lastFrame.getFrameNum()) / totalf;
            if (i - 1 < 1) {
                prevFrame = this.frames[i - 1];
                adj0 = 0.0;
            } else {
                prevFrame = this.frames[i - 2];
                adj0 = tlength / ((thisFrame.getFrameNum() - prevFrame.getFrameNum()) / totalf);
            }
            if (i + 1 < this.numFrames) {
                nextFrame = this.frames[i + 1];
                adj1 = tlength / ((nextFrame.getFrameNum() - lastFrame.getFrameNum()) / totalf);
            } else {
                nextFrame = this.frames[i];
                adj1 = 1.0;
            }
            for (int j = 0; j < numNewFrames; ++j) {
                LwsFrame newFrame = thisFrame.linearValue == 1 ? new LwsFrame(lastFrame, thisFrame, currentRatio) : new LwsFrame(prevFrame, lastFrame, thisFrame, nextFrame, currentRatio, adj0, adj1);
                currentRatio += increment;
                newFramesList.add(newFrame);
            }
        }
        if (finalFrame != null) {
            newFramesList.add(finalFrame);
        }
        if (addedFrames) {
            LwsFrame[] newFrames = new LwsFrame[newFramesList.size()];
            Enumeration elements = newFramesList.elements();
            int index = 0;
            while (elements.hasMoreElements()) {
                newFrames[index++] = (LwsFrame)elements.nextElement();
            }
            this.frames = newFrames;
            this.numFrames = this.frames.length;
            for (int i = 0; i < this.numFrames; ++i) {
                this.debugOutputLn(2, "frame " + i + " = " + this.frames[i]);
                this.frames[i].printVals();
            }
        }
    }

    int intMod(int divisee, int divisor) {
        int tmpDiv = divisee;
        int tmpDivisor = divisor;
        if (tmpDiv < 0) {
            tmpDiv = -tmpDiv;
        }
        if (tmpDivisor < 0) {
            tmpDivisor = -tmpDivisor;
        }
        while (tmpDiv > tmpDivisor) {
            tmpDiv -= tmpDivisor;
        }
        return tmpDiv;
    }

    void playWithFrameTimes(Vector framesVector) {
        this.debugOutputLn(1, "playWithFrameTimes: firstFrame = " + this.firstFrame);
        if (this.firstFrame == 1) {
            return;
        }
        if (this.frames[this.numFrames - 1].getFrameNum() < (double)this.totalFrames) {
            int index;
            int motionLastFrame = (int)(this.frames[this.numFrames - 1].getFrameNum() + 0.4999999);
            int newFirstFrame = this.intMod(this.firstFrame, motionLastFrame);
            int newLastFrame = this.intMod(this.totalFrames, motionLastFrame);
            for (index = 0; index < this.numFrames && !(this.frames[index].getFrameNum() >= (double)newFirstFrame); ++index) {
            }
            int startIndex = index;
            if (this.frames[startIndex].getFrameNum() > (double)this.firstFrame && startIndex > 0) {
                --startIndex;
            }
            if (newFirstFrame < newLastFrame) {
                for (index = startIndex; index < this.numFrames && this.frames[index].getFrameNum() <= (double)newLastFrame; ++index) {
                    FrameHolder frameHolder = new FrameHolder(this.frames[index], this.frames[index].getFrameNum() - (double)newFirstFrame);
                    framesVector.addElement(frameHolder);
                }
            } else {
                FrameHolder frameHolder;
                double currentNewFrameNumber = -1.0;
                while (index < this.numFrames) {
                    currentNewFrameNumber = this.frames[index].getFrameNum() - (double)newFirstFrame;
                    frameHolder = new FrameHolder(this.frames[index], currentNewFrameNumber);
                    framesVector.addElement(frameHolder);
                    ++index;
                }
                for (index = 0; index <= startIndex && this.frames[index].getFrameNum() <= (double)newLastFrame; ++index) {
                    if (index == 0) {
                        LwsFrame newFrame = new LwsFrame(this.frames[index], this.frames[index + 1], 1.0 / (this.frames[index + 1].getFrameNum() - this.frames[index].getFrameNum()));
                        FrameHolder frameHolder2 = new FrameHolder(newFrame, newFrame.getFrameNum() + currentNewFrameNumber);
                        framesVector.addElement(frameHolder2);
                        continue;
                    }
                    frameHolder = new FrameHolder(this.frames[index], this.frames[index].getFrameNum() + currentNewFrameNumber);
                    framesVector.addElement(frameHolder);
                }
            }
        } else {
            FrameHolder frameHolder;
            LwsFrame newFrame;
            int index;
            for (index = 0; index < this.numFrames && !(this.frames[index].getFrameNum() >= (double)this.firstFrame); ++index) {
            }
            int startIndex = index;
            if (this.frames[startIndex].getFrameNum() > (double)this.firstFrame && startIndex > 0) {
                double ratio = (double)this.firstFrame / (this.frames[startIndex].getFrameNum() - this.frames[startIndex - 1].getFrameNum());
                newFrame = new LwsFrame(this.frames[startIndex - 1], this.frames[startIndex], ratio);
                frameHolder = new FrameHolder(newFrame, newFrame.getFrameNum() - (double)this.firstFrame);
                framesVector.addElement(frameHolder);
            }
            for (index = startIndex; index < this.numFrames && this.frames[index].getFrameNum() <= (double)this.totalFrames; ++index) {
                FrameHolder frameHolder3 = new FrameHolder(this.frames[index], this.frames[index].getFrameNum() - (double)this.firstFrame);
                framesVector.addElement(frameHolder3);
            }
            if (this.frames[index - 1].getFrameNum() < (double)this.totalFrames) {
                double ratio = ((double)this.totalFrames - this.frames[index - 1].getFrameNum()) / (this.frames[index].getFrameNum() - this.frames[index - 1].getFrameNum());
                newFrame = new LwsFrame(this.frames[index - 1], this.frames[index], ratio);
                frameHolder = new FrameHolder(newFrame, this.totalFrames - this.firstFrame);
                framesVector.addElement(frameHolder);
            }
        }
    }

    void createJava3dBehaviorsForFramesSubset(TransformGroup target) {
        this.debugOutputLn(1, "createJava3dBehaviorsForFramesSubset");
        Vector frameHolders = new Vector();
        this.playWithFrameTimes(frameHolders);
        long alphaAtOne = 0L;
        int loopCount = this.loop ? -1 : 1;
        loopCount = -1;
        int numFrames = frameHolders.size();
        this.debugOutputLn(2, "totalTime = " + this.totalTime);
        this.debugOutputLn(2, "loopCount = " + loopCount);
        FrameHolder lastFrameHolder = (FrameHolder)frameHolders.elementAt(frameHolders.size() - 1);
        LwsFrame lastFrame = lastFrameHolder.frame;
        float animTime = 1000.0f * this.totalTime * (float)(lastFrameHolder.frameNumber / (double)(this.totalFrames - this.firstFrame));
        this.debugOutputLn(2, " anim time: " + animTime);
        this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
        if (!this.loop) {
            alphaAtOne = (long)(1000.0 * (double)this.totalTime - (double)animTime);
        }
        Alpha theAlpha = new Alpha(loopCount, 1, 0L, 0L, (long)animTime, 0L, alphaAtOne, 0L, 0L, 0L);
        float[] knots = new float[numFrames];
        Point3f[] positions = new Point3f[numFrames];
        Quat4f[] quats = new Quat4f[numFrames];
        Point3f[] scales = new Point3f[numFrames];
        Transform3D yAxis = new Transform3D();
        Matrix4d mat = new Matrix4d();
        KBKeyFrame[] keyFrames = new KBKeyFrame[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            FrameHolder frameHolder = (FrameHolder)frameHolders.elementAt(i);
            LwsFrame frame = frameHolder.frame;
            positions[i] = frame.getPosition();
            scales[i] = frame.getScale();
            frame.setRotationMatrix(mat);
            this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + mat);
            quats[i] = new Quat4f();
            quats[i].set(mat);
            this.debugOutputLn(2, " and quat = " + quats[i]);
            knots[i] = i == 0 ? 0.0f : (float)frameHolder.frameNumber / (float)lastFrameHolder.frameNumber;
            keyFrames[i] = new KBKeyFrame(knots[i], frame.linearValue, positions[i], (float)frame.heading, (float)frame.pitch, (float)frame.bank, scales[i], (float)frame.tension, (float)frame.continuity, (float)frame.bias);
            this.debugOutputLn(2, "pos, knots, quat = " + positions[i] + knots[i] + quats[i]);
        }
        KBRotPosScaleSplinePathInterpolator b = new KBRotPosScaleSplinePathInterpolator(theAlpha, target, yAxis, keyFrames);
        if (b != null) {
            this.behaviors = b;
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
            b.setSchedulingBounds((Bounds)bounds);
            target.setCapability(18);
            target.addChild((Node)this.behaviors);
        }
    }

    void createJava3dBehaviors(TransformGroup target) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            if (this.firstFrame > 1) {
                this.createJava3dBehaviorsForFramesSubset(target);
                return;
            }
            long alphaAtOne = 0L;
            int loopCount = this.loop ? -1 : 1;
            loopCount = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + loopCount);
            float animTime = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + animTime);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                alphaAtOne = (long)(1000.0 * (double)this.totalTime - (double)animTime);
            }
            Alpha theAlpha = new Alpha(loopCount, 1, 0L, 0L, (long)animTime, 0L, alphaAtOne, 0L, 0L, 0L);
            float[] knots = new float[this.numFrames];
            Point3f[] positions = new Point3f[this.numFrames];
            Quat4f[] quats = new Quat4f[this.numFrames];
            Point3f[] scales = new Point3f[this.numFrames];
            Transform3D yAxis = new Transform3D();
            Matrix4d mat = new Matrix4d();
            KBKeyFrame[] keyFrames = new KBKeyFrame[this.numFrames];
            for (int i = 0; i < this.numFrames; ++i) {
                positions[i] = this.frames[i].getPosition();
                scales[i] = this.frames[i].getScale();
                this.frames[i].setRotationMatrix(mat);
                this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + mat);
                quats[i] = new Quat4f();
                quats[i].set(mat);
                this.debugOutputLn(2, " and quat = " + quats[i]);
                knots[i] = i == 0 ? 0.0f : (float)this.frames[i].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                keyFrames[i] = new KBKeyFrame(knots[i], this.frames[i].linearValue, positions[i], (float)this.frames[i].heading, (float)this.frames[i].pitch, (float)this.frames[i].bank, scales[i], (float)this.frames[i].tension, (float)this.frames[i].continuity, (float)this.frames[i].bias);
                this.debugOutputLn(2, "pos, knots, quat = " + positions[i] + knots[i] + quats[i]);
            }
            KBRotPosScaleSplinePathInterpolator b = new KBRotPosScaleSplinePathInterpolator(theAlpha, target, yAxis, keyFrames);
            if (b != null) {
                this.behaviors = b;
                BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                b.setSchedulingBounds((Bounds)bounds);
                target.setCapability(18);
                target.addChild((Node)this.behaviors);
            }
        }
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    LwsFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   motionName = " + this.motionName);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        for (int i = 0; i < this.numFrames; ++i) {
            this.debugOutputLn(2, "       FRAME " + i);
            this.frames[i].printVals();
        }
    }

    class FrameHolder {
        double frameNumber;
        LwsFrame frame;

        FrameHolder(LwsFrame theFrame, double number) {
            this.frame = theFrame;
            this.frameNumber = number;
        }
    }
}

