/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.picking.behaviors;

import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Node;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.behaviors.mouse.MouseBehaviorCallback;
import org.scijava.java3d.utils.behaviors.mouse.MouseRotate;
import org.scijava.java3d.utils.picking.PickResult;
import org.scijava.java3d.utils.picking.behaviors.PickMouseBehavior;
import org.scijava.java3d.utils.picking.behaviors.PickingCallback;

public class PickRotateBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    MouseRotate drag = new MouseRotate(1);
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.drag.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.drag);
        this.drag.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public PickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.drag.setTransformGroup(this.currGrp);
        this.currGrp.addChild((Node)this.drag);
        this.drag.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (!this.mevent.isMetaDown() && !this.mevent.isAltDown()) {
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult pr = this.pickCanvas.pickClosest();
            if (pr != null && (tg = (TransformGroup)pr.getNode(32)) != null && tg.getCapability(17) && tg.getCapability(18)) {
                this.drag.setTransformGroup(tg);
                this.drag.wakeup();
                this.currentTG = tg;
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(0, this.currentTG);
    }

    public void setupCallback(PickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.drag.setupCallback(null);
        } else {
            this.drag.setupCallback(this);
        }
    }
}

