/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.AlternateAppearance;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Group;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;

public class AlternateAppearanceState
extends LeafState {
    private int[] scopes;
    private int appearance;
    private int influencingBoundingLeaf;

    public AlternateAppearanceState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.scopes = new int[((AlternateAppearance)this.node).numScopes()];
            for (int i = 0; i < this.scopes.length; ++i) {
                this.scopes[i] = control.getSymbolTable().addReference((SceneGraphObject)((AlternateAppearance)this.node).getScope(i));
            }
            this.appearance = control.getSymbolTable().addReference((SceneGraphObject)((AlternateAppearance)this.node).getAppearance());
            this.influencingBoundingLeaf = control.getSymbolTable().addReference((SceneGraphObject)((AlternateAppearance)this.node).getInfluencingBoundingLeaf());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.scopes.length);
        for (int i = 0; i < this.scopes.length; ++i) {
            out.writeInt(this.scopes[i]);
        }
        out.writeInt(this.appearance);
        out.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(out, ((AlternateAppearance)this.node).getInfluencingBounds());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.scopes = new int[in.readInt()];
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = in.readInt();
        }
        this.appearance = in.readInt();
        this.influencingBoundingLeaf = in.readInt();
        ((AlternateAppearance)this.node).setInfluencingBounds(this.control.readBounds(in));
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
    }

    @Override
    public void buildGraph() {
        for (int i = 0; i < this.scopes.length; ++i) {
            ((AlternateAppearance)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
        }
        ((AlternateAppearance)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        ((AlternateAppearance)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new AlternateAppearance();
    }
}

