/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Group;
import org.scijava.java3d.ModelClip;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;
import org.scijava.vecmath.Vector4d;

public class ModelClipState
extends LeafState {
    private int[] scopes;
    private int influencingBoundingLeaf;

    public ModelClipState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.scopes = new int[((ModelClip)this.node).numScopes()];
            for (int i = 0; i < this.scopes.length; ++i) {
                this.scopes[i] = control.getSymbolTable().addReference((SceneGraphObject)((ModelClip)this.node).getScope(i));
            }
            this.influencingBoundingLeaf = control.getSymbolTable().addReference((SceneGraphObject)((ModelClip)this.node).getInfluencingBoundingLeaf());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        boolean[] enables = new boolean[6];
        ((ModelClip)this.node).getEnables(enables);
        out.writeInt(this.scopes.length);
        for (int i = 0; i < this.scopes.length; ++i) {
            out.writeInt(this.scopes[i]);
        }
        out.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(out, ((ModelClip)this.node).getInfluencingBounds());
        Vector4d[] planes = new Vector4d[6];
        ((ModelClip)this.node).getPlanes(planes);
        for (int i = 0; i < 6; ++i) {
            out.writeBoolean(enables[i]);
            this.control.writeVector4d(out, planes[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.scopes = new int[in.readInt()];
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = in.readInt();
        }
        this.influencingBoundingLeaf = in.readInt();
        ((ModelClip)this.node).setInfluencingBounds(this.control.readBounds(in));
        boolean[] enables = new boolean[6];
        Vector4d[] planes = new Vector4d[6];
        for (int i = 0; i < 6; ++i) {
            enables[i] = in.readBoolean();
            planes[i] = this.control.readVector4d(in);
        }
        ((ModelClip)this.node).setEnables(enables);
        ((ModelClip)this.node).setPlanes(planes);
    }

    @Override
    public void buildGraph() {
        for (int i = 0; i < this.scopes.length; ++i) {
            ((ModelClip)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
        }
        ((ModelClip)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ModelClip();
    }
}

