/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.universe;

import org.scijava.java3d.Node;
import org.scijava.java3d.TransformGroup;

public class MultiTransformGroup {
    TransformGroup[] transforms;

    public MultiTransformGroup() {
        this(1);
    }

    public MultiTransformGroup(int numTransforms) {
        if (numTransforms < 1) {
            numTransforms = 1;
        }
        this.transforms = new TransformGroup[numTransforms];
        this.transforms[0] = new TransformGroup();
        this.transforms[0].setCapability(18);
        this.transforms[0].setCapability(17);
        this.transforms[0].setCapability(13);
        this.transforms[0].setCapability(14);
        for (int i = 1; i < numTransforms; ++i) {
            this.transforms[i] = new TransformGroup();
            this.transforms[i].setCapability(18);
            this.transforms[i].setCapability(17);
            this.transforms[i].setCapability(13);
            this.transforms[i].setCapability(14);
            this.transforms[i - 1].addChild((Node)this.transforms[i]);
        }
    }

    public TransformGroup getTransformGroup(int transform) {
        if (transform >= this.transforms.length || transform < 0) {
            return null;
        }
        return this.transforms[transform];
    }

    public int getNumTransforms() {
        return this.transforms.length;
    }
}

