/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.scijava.nativelib.DefaultJniExtractor;
import org.scijava.nativelib.NativeLibraryUtil;
import org.scijava.nativelib.NativeLoader;

public class NativeLoaderTest {
    @Rule
    public TemporaryFolder tmpTestDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar() throws Exception {
        File dummyJar = this.tmpTestDir.newFile("dummy.jar");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ZipOutputStream target = null;
        try {
            target = new JarOutputStream((OutputStream)new FileOutputStream(dummyJar), manifest);
            File source = new File(String.format("natives/%s/%s", NativeLibraryUtil.getArchitecture().name().toLowerCase(), NativeLibraryUtil.getPlatformLibraryName((String)"dummy")));
            JarEntry entry = new JarEntry(source.getPath().replace("\\", "/"));
            entry.setTime(System.currentTimeMillis());
            ((JarOutputStream)target).putNextEntry(entry);
            byte[] buffer = "native-lib-loader".getBytes();
            target.write(buffer, 0, buffer.length);
            target.closeEntry();
        }
        finally {
            if (target != null) {
                target.close();
            }
        }
        Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURLMethod.setAccessible(true);
        addURLMethod.invoke((Object)ClassLoader.getSystemClassLoader(), dummyJar.toURI().toURL());
    }

    @Test(expected=IOException.class)
    public void exampleHowToUse() throws Exception {
        NativeLoader.loadLibrary((String)"mylib", (String[])new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtracting() throws Exception {
        this.createJar();
        DefaultJniExtractor jniExtractor = new DefaultJniExtractor(null);
        String libPath = String.format("natives/%s", NativeLibraryUtil.getArchitecture().name().toLowerCase());
        File extracted = jniExtractor.extractJni(libPath + "", "dummy");
        FileInputStream in = null;
        try {
            in = new FileInputStream(extracted);
            byte[] buffer = new byte[32];
            in.read(buffer, 0, buffer.length);
            Assert.assertTrue((boolean)new String(buffer).trim().equals("native-lib-loader"));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

