/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations.legacy;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LegacyReader {
    private static final short STREAM_MAGIC = -21267;
    private static final short STREAM_VERSION = 5;
    private static final byte TC_NULL = 112;
    private static final byte TC_REFERENCE = 113;
    private static final byte TC_CLASSDESC = 114;
    private static final byte TC_OBJECT = 115;
    private static final byte TC_STRING = 116;
    private static final byte TC_BLOCKDATA = 119;
    private static final byte TC_ENDBLOCKDATA = 120;
    private static final byte SC_WRITE_METHOD = 1;
    private static final byte SC_SERIALIZABLE = 2;
    private static final int HANDLE_OFFSET = 0x7E0000;
    private final InputStream in;
    private final List<Object> references;
    private final Map<String, ClassDesc> classDescs = new HashMap<String, ClassDesc>();

    public LegacyReader(InputStream in) throws IOException {
        new ClassDesc("B"){

            @Override
            public Object read() throws IOException {
                return (long)((byte)LegacyReader.this.read8());
            }
        };
        new ClassDesc("C"){

            @Override
            public Object read() throws IOException {
                return "" + (char)LegacyReader.this.read16();
            }
        };
        new ClassDesc("D"){

            @Override
            public Object read() throws IOException {
                return Double.longBitsToDouble(LegacyReader.this.read64());
            }
        };
        new ClassDesc("F"){

            @Override
            public Object read() throws IOException {
                return (double)Float.intBitsToFloat(LegacyReader.this.read32());
            }
        };
        new ClassDesc("I"){

            @Override
            public Object read() throws IOException {
                return (long)LegacyReader.this.read32();
            }
        };
        new ClassDesc("J"){

            @Override
            public Object read() throws IOException {
                return LegacyReader.this.read64();
            }
        };
        new ClassDesc("S"){

            @Override
            public Object read() throws IOException {
                return (long)((short)LegacyReader.this.read16());
            }
        };
        new ClassDesc("Z"){

            @Override
            public Object read() throws IOException {
                return LegacyReader.this.read8() != 0;
            }
        };
        new ClassDesc("Ljava/lang/String;"){

            @Override
            public Object read() throws IOException {
                return (String)LegacyReader.this.readObject();
            }
        };
        new BoxedPrimitiveClassDesc(Boolean.class, "Z");
        new BoxedPrimitiveClassDesc(Byte.class, "B");
        new BoxedPrimitiveClassDesc(Short.class, "S");
        new BoxedPrimitiveClassDesc(Integer.class, "I");
        new BoxedPrimitiveClassDesc(Long.class, "J");
        new BoxedPrimitiveClassDesc(Float.class, "F");
        new BoxedPrimitiveClassDesc(Double.class, "D");
        new InterfaceClassDesc(Number.class);
        new InterfaceClassDesc(Comparator.class);
        new NonPrimitiveClassDesc(LegacyReader.toSimpleName(Character.class), new Object[]{"value", "C"}){

            @Override
            public Object readExtra(Map<String, Object> map) {
                return (String)map.get("value");
            }
        };
        new NonPrimitiveClassDesc(LegacyReader.toSimpleName(TreeMap.class), new Object[]{"comparator", "Ljava/util/Comparator;"}){

            @Override
            public Map<String, Object> readExtra(Map<String, Object> map) throws IOException {
                if (map.size() != 1 || !map.containsKey("comparator")) {
                    throw new IOException("Unexpected comparator");
                }
                map.clear();
                LegacyReader.this.expectToken(119);
                LegacyReader.this.expectToken(4);
                int size = LegacyReader.this.read32();
                for (int i = 0; i < size; ++i) {
                    String key = (String)LegacyReader.this.readObject();
                    Object value = LegacyReader.this.readObject();
                    map.put(key, value);
                }
                LegacyReader.this.expectToken(120);
                return map;
            }
        };
        new NonPrimitiveClassDesc(LegacyReader.toSimpleName(ArrayList.class), new Object[]{"size", "I"}){

            @Override
            public Object readExtra(Map<String, Object> map) throws IOException {
                int size = (int)((Long)map.get("size")).longValue();
                map.clear();
                LegacyReader.this.expectToken(119);
                LegacyReader.this.expectToken(4);
                int capacity = LegacyReader.this.read32();
                ArrayList<Object> list = new ArrayList<Object>(capacity);
                for (int i = 0; i < size; ++i) {
                    list.add(LegacyReader.this.readObject());
                }
                LegacyReader.this.expectToken(120);
                return list;
            }
        };
        new NonPrimitiveClassDesc("Lnet/java/sezpoz/impl/SerAnnotatedElement;", new Object[]{"isMethod", "Z", "className", "Ljava/lang/String;", "memberName", "Ljava/lang/String;", "values", "Ljava/util/TreeMap;"}){

            @Override
            public Object readExtra(Map<String, Object> map) throws IOException {
                map.put("class", map.get("className"));
                return map;
            }
        };
        new NonPrimitiveClassDesc("Lnet/java/sezpoz/impl/SerAnnConst;", new Object[]{"name", "Ljava/lang/String;", "values", "Ljava/util/TreeMap;"}){

            @Override
            public Object readExtra(Map<String, Object> map) throws IOException {
                return map.get("values");
            }
        };
        new NonPrimitiveClassDesc("Lnet/java/sezpoz/impl/SerEnumConst;", new Object[]{"enumName", "Ljava/lang/String;", "constName", "Ljava/lang/String;"}){

            @Override
            public Object readExtra(Map<String, Object> map) throws IOException {
                map.put("enum", map.get("enumName"));
                map.put("value", map.get("constName"));
                return map;
            }
        };
        new NonPrimitiveClassDesc("Lnet/java/sezpoz/impl/SerTypeConst;", new Object[]{"name", "Ljava/lang/String;"}){

            @Override
            public Object readExtra(Map<String, Object> map) throws IOException {
                return map.get("name");
            }
        };
        this.in = new BufferedInputStream(in);
        short signature = (short)this.read16();
        if (signature != -21267) {
            throw new IOException("Unrecognized signature: 0x" + Integer.toHexString(signature));
        }
        int version = this.read16();
        if (version != 5) {
            throw new IOException("Unsupported version: " + version);
        }
        this.references = new ArrayList<Object>();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Object readObject() throws IOException {
        int c = this.read8();
        if (c == 112) {
            return null;
        }
        if (c == 116) {
            int length = this.read16();
            byte[] bytes = new byte[length];
            this.readFully(bytes);
            String s = new String(bytes, "UTF-8");
            this.references.add(s);
            return s;
        }
        if (c == 113) {
            int handle = this.read32() - 0x7E0000;
            return this.references.get(handle);
        }
        if (c != 115) {
            throw new IOException("Unexpected token: 0x" + Integer.toHexString(c));
        }
        return this.readClassDesc().readWithoutClassDesc();
    }

    private ClassDesc readClassDesc() throws IOException {
        int c = this.read8();
        if (c == 113) {
            int handle = this.read32() - 0x7E0000;
            return (ClassDesc)this.references.get(handle);
        }
        if (c == 114) {
            return this.newClassDesc();
        }
        throw new UnsupportedOperationException("Unexpected token: 0x" + Integer.toHexString(c));
    }

    private void expectToken(int token) throws IOException {
        int c = this.read8();
        if (c != token) {
            throw new UnsupportedOperationException("Unexpected token: 0x" + Integer.toHexString(c));
        }
    }

    private int read8() throws IOException {
        return this.in.read() & 0xFF;
    }

    private int read16() throws IOException {
        return this.read8() << 8 | this.read8();
    }

    private int read32() throws IOException {
        return this.read16() << 16 | this.read16();
    }

    private long read64() throws IOException {
        return ((long)this.read32() & 0xFFFFFFFFL) << 32 | (long)this.read32();
    }

    private String readString() throws IOException {
        int length = this.read16();
        byte[] array = new byte[length];
        this.readFully(array);
        return new String(array);
    }

    private void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    private void readFully(byte[] b, int offset, int length) throws IOException {
        while (length > 0) {
            int count = this.in.read(b, offset, length);
            if (count < 0) {
                throw new EOFException("Reached EOF " + length + " bytes too early");
            }
            offset += count;
            length -= count;
        }
    }

    private ClassDesc newClassDesc() throws IOException {
        String className = this.readString();
        long serialVersionUID = this.read64();
        String rawName = "L" + className.replace('.', '/') + ";";
        ClassDesc result = this.classDescs.get(rawName);
        if (result == null) {
            throw new IOException("Could not find class for " + className + ", serial " + serialVersionUID);
        }
        this.references.add(result);
        int flags = this.read8();
        if ((flags & 0xFFFFFFFC) != 0) {
            throw new UnsupportedOperationException("Cannot handle flags: 0x" + Integer.toHexString(flags));
        }
        int fieldCount = this.read16();
        if (fieldCount != result.fields.size()) {
            throw new IOException("Incompatible field count: " + fieldCount + " vs " + result.fields.size());
        }
        result.order = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            int typeChar = this.read8();
            String fieldName = this.readString();
            if (!result.fields.containsKey(fieldName)) {
                throw new IOException("Unexpected field " + fieldName);
            }
            result.order[i] = fieldName;
            String type = "" + (char)typeChar;
            if (typeChar == 91 || typeChar == 76) {
                type = (String)this.readObject();
            }
            if (type.equals(result.fields.get((Object)fieldName).className)) continue;
            throw new IOException(fieldName + " has type " + type + " instead of expected " + result.fields.get((Object)fieldName).className);
        }
        this.expectToken(120);
        int c = this.read8();
        Object superClassDesc = null;
        if (c == 114) {
            superClassDesc = this.newClassDesc();
        } else if (c == 113) {
            int handle = this.read32() - 0x7E0000;
            superClassDesc = this.references.get(handle);
        } else if (c != 112) {
            throw new UnsupportedOperationException("Unexpected token: 0x" + Integer.toHexString(c));
        }
        return result;
    }

    public static String toSimpleName(Class<?> clazz) {
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private class InterfaceClassDesc
    extends NonPrimitiveClassDesc {
        protected InterfaceClassDesc(Class<?> clazz) {
            super(LegacyReader.toSimpleName(clazz), new Object[0]);
        }

        @Override
        public Object read() throws IOException {
            return LegacyReader.this.readObject();
        }
    }

    private class BoxedPrimitiveClassDesc
    extends NonPrimitiveClassDesc {
        private final Class<?> clazz;

        public BoxedPrimitiveClassDesc(Class<?> clazz, String simpleName) {
            super(LegacyReader.toSimpleName(clazz), "value", simpleName);
            this.clazz = clazz == Double.class || clazz == Float.class ? Double.class : (clazz == Boolean.class ? Boolean.class : Long.class);
        }

        @Override
        public Object readExtra(Map<String, Object> map) throws IOException {
            return this.clazz.cast(map.get("value"));
        }
    }

    private class NonPrimitiveClassDesc
    extends ClassDesc {
        protected NonPrimitiveClassDesc(String className, Object ... fields) {
            super(className);
            if (fields.length % 2 != 0) {
                throw new RuntimeException("That's odd: " + fields.length);
            }
            this.fields = new LinkedHashMap();
            for (int i = 0; i < fields.length; i += 2) {
                ClassDesc classDesc;
                String name = (String)fields[i];
                if (fields[i + 1] instanceof ClassDesc) {
                    classDesc = (ClassDesc)fields[i + 1];
                } else if (fields[i + 1] instanceof String) {
                    classDesc = (ClassDesc)LegacyReader.this.classDescs.get((String)fields[i + 1]);
                    if (classDesc == null) {
                        throw new RuntimeException("Could not find class desc for " + fields[i + 1]);
                    }
                } else {
                    throw new RuntimeException("Invalid class desc: " + fields[i + 1]);
                }
                this.fields.put(name, classDesc);
            }
        }

        @Override
        protected Object read() throws IOException {
            int c = LegacyReader.this.read8();
            if (c == 112) {
                return null;
            }
            if (c != 115) {
                throw new IOException("Unexpected token: " + Integer.toHexString(c));
            }
            ClassDesc classDesc = LegacyReader.this.readClassDesc();
            if (classDesc != this) {
                throw new IOException("ClassDesc mismatch: " + this.className + " was expected, but got " + classDesc.className);
            }
            return this.readWithoutClassDesc();
        }

        @Override
        protected final Object readWithoutClassDesc() throws IOException {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int index = LegacyReader.this.references.size();
            LegacyReader.this.references.add(map);
            for (String fieldName : this.order) {
                ClassDesc classDesc = (ClassDesc)this.fields.get(fieldName);
                map.put(fieldName, classDesc.read());
            }
            Object o = this.readExtra(map);
            if (o != map) {
                LegacyReader.this.references.set(index, o);
            }
            return o;
        }

        protected Object readExtra(Map<String, Object> o) throws IOException {
            return o;
        }
    }

    private abstract class ClassDesc {
        protected String[] order;
        protected final String className;
        protected Map<String, ClassDesc> fields;

        protected ClassDesc(String className) {
            this.className = className;
            LegacyReader.this.classDescs.put(className, this);
        }

        protected abstract Object read() throws IOException;

        protected Object readWithoutClassDesc() throws IOException {
            return this.read();
        }
    }
}

