/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.NullContextException;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModule;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.util.ConversionUtils;
import org.scijava.util.FileUtils;

public class ScriptModule
extends AbstractModule
implements Contextual {
    public static final String RETURN_VALUE = "result";
    private final ScriptInfo info;
    @Parameter
    private Context context;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private LogService log;
    private ScriptLanguage scriptLanguage;
    private ScriptEngine scriptEngine;
    private Writer output;
    private Writer error;

    public ScriptModule(ScriptInfo info) {
        this.info = info;
    }

    public ScriptLanguage getLanguage() {
        if (this.scriptLanguage == null) {
            String path = this.getInfo().getPath();
            String extension = FileUtils.getExtension(path);
            this.scriptLanguage = this.scriptService.getLanguageByExtension(extension);
        }
        return this.scriptLanguage;
    }

    public void setLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setOutputWriter(Writer output) {
        this.output = output;
    }

    public void setErrorWriter(Writer error) {
        this.error = error;
    }

    public ScriptEngine getEngine() {
        if (this.scriptEngine == null) {
            this.scriptEngine = this.getLanguage().getScriptEngine();
        }
        return this.scriptEngine;
    }

    public Object getReturnValue() {
        return this.getOutput(RETURN_VALUE);
    }

    @Override
    public ScriptInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        ScriptEngine engine = this.getEngine();
        String path = this.getInfo().getPath();
        engine.put("javax.script.filename", path);
        ScriptContext scriptContext = engine.getContext();
        if (this.output != null) {
            scriptContext.setWriter(this.output);
        }
        if (this.error != null) {
            scriptContext.setErrorWriter(this.error);
        }
        for (ModuleItem<?> item : this.getInfo().inputs()) {
            String name = item.getName();
            engine.put(name, this.getInput(name));
        }
        ScriptLanguage language = this.getLanguage();
        try {
            BufferedReader reader = this.getInfo().getReader();
            Object returnValue = reader == null ? engine.eval(new FileReader(path)) : engine.eval(reader);
            this.setOutput(RETURN_VALUE, language.decode(returnValue));
            this.setResolved(RETURN_VALUE, true);
        }
        catch (ScriptException e) {
            this.log.error(e.getCause());
        }
        catch (Throwable e) {
            this.log.error(e);
        }
        for (ModuleItem<?> item : this.getInfo().outputs()) {
            String name = item.getName();
            if (this.isResolved(name)) continue;
            Object value = engine.get(name);
            Object decoded = language.decode(value);
            Object typed = ConversionUtils.convert(decoded, item.getType());
            this.setOutput(name, typed);
        }
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }
}

