/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.MenuPath;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptFinder;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.test.TestUtils;
import org.scijava.util.AppUtils;
import org.scijava.util.FileUtils;

public class ScriptFinderTest {
    private static File scriptsDir;

    @BeforeClass
    public static void setUp() throws IOException {
        scriptsDir = TestUtils.createTemporaryDirectory((String)"script-finder-");
        TestUtils.createPath((File)scriptsDir, (String)"ignored.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Scripts/quick.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Scripts/brown.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Scripts/fox.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Scripts/The_Lazy_Dog.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/add.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/subtract.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/multiply.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/divide.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/Trig/cos.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/Trig/sin.foo");
        TestUtils.createPath((File)scriptsDir, (String)"Math/Trig/tan.foo");
    }

    @AfterClass
    public static void tearDown() {
        FileUtils.deleteRecursively((File)scriptsDir);
    }

    @Test
    public void testFindScripts() {
        ScriptService scriptService = this.createScriptService();
        scriptService.addScriptDirectory(scriptsDir);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        Assert.assertEquals((long)11L, (long)scripts.size());
        this.assertMenuPath("Scripts > The Lazy Dog", scripts, 0);
        this.assertMenuPath("Math > add", scripts, 1);
        this.assertMenuPath("Scripts > brown", scripts, 2);
        this.assertMenuPath("Math > Trig > cos", scripts, 3);
        this.assertMenuPath("Math > divide", scripts, 4);
        this.assertMenuPath("Scripts > fox", scripts, 5);
        this.assertMenuPath("Math > multiply", scripts, 6);
        this.assertMenuPath("Scripts > quick", scripts, 7);
        this.assertMenuPath("Math > Trig > sin", scripts, 8);
        this.assertMenuPath("Math > subtract", scripts, 9);
        this.assertMenuPath("Math > Trig > tan", scripts, 10);
    }

    @Test
    public void testMenuPrefixes() {
        ScriptService scriptService = this.createScriptService();
        MenuPath menuPrefix = new MenuPath("Foo > Bar");
        Assert.assertEquals((long)2L, (long)menuPrefix.size());
        Assert.assertEquals((Object)"Bar", (Object)menuPrefix.getLeaf().getName());
        scriptService.addScriptDirectory(scriptsDir, menuPrefix);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        Assert.assertEquals((long)12L, (long)scripts.size());
        this.assertMenuPath("Foo > Bar > Scripts > The Lazy Dog", scripts, 0);
        this.assertMenuPath("Foo > Bar > Math > add", scripts, 1);
        this.assertMenuPath("Foo > Bar > Scripts > brown", scripts, 2);
        this.assertMenuPath("Foo > Bar > Math > Trig > cos", scripts, 3);
        this.assertMenuPath("Foo > Bar > Math > divide", scripts, 4);
        this.assertMenuPath("Foo > Bar > Scripts > fox", scripts, 5);
        this.assertMenuPath("Foo > Bar > ignored", scripts, 6);
        this.assertMenuPath("Foo > Bar > Math > multiply", scripts, 7);
        this.assertMenuPath("Foo > Bar > Scripts > quick", scripts, 8);
        this.assertMenuPath("Foo > Bar > Math > Trig > sin", scripts, 9);
        this.assertMenuPath("Foo > Bar > Math > subtract", scripts, 10);
        this.assertMenuPath("Foo > Bar > Math > Trig > tan", scripts, 11);
    }

    @Test
    public void testOverlappingDirectories() {
        ScriptService scriptService = this.createScriptService();
        scriptService.addScriptDirectory(new File(scriptsDir, "Scripts"), new MenuPath("Plugins"));
        scriptService.addScriptDirectory(scriptsDir);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        Assert.assertEquals((long)11L, (long)scripts.size());
        this.assertMenuPath("Plugins > The Lazy Dog", scripts, 0);
        this.assertMenuPath("Math > add", scripts, 1);
        this.assertMenuPath("Plugins > brown", scripts, 2);
        this.assertMenuPath("Math > Trig > cos", scripts, 3);
        this.assertMenuPath("Math > divide", scripts, 4);
        this.assertMenuPath("Plugins > fox", scripts, 5);
        this.assertMenuPath("Math > multiply", scripts, 6);
        this.assertMenuPath("Plugins > quick", scripts, 7);
        this.assertMenuPath("Math > Trig > sin", scripts, 8);
        this.assertMenuPath("Math > subtract", scripts, 9);
        this.assertMenuPath("Math > Trig > tan", scripts, 10);
    }

    private ScriptService createScriptService() {
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.service(ScriptService.class);
        File defaultScriptsDir = new File(AppUtils.getBaseDirectory(ScriptFinder.class), "scripts");
        scriptService.removeScriptDirectory(defaultScriptsDir);
        return scriptService;
    }

    private ArrayList<ScriptInfo> findScripts(ScriptService scriptService) {
        ScriptFinder scriptFinder = new ScriptFinder(scriptService);
        ArrayList<ScriptInfo> scripts = new ArrayList<ScriptInfo>();
        scriptFinder.findScripts(scripts);
        Collections.sort(scripts);
        return scripts;
    }

    private void assertMenuPath(String menuString, ArrayList<ScriptInfo> scripts, int i) {
        Assert.assertEquals((Object)menuString, (Object)scripts.get(i).getMenuPath().getMenuString());
    }

    @Plugin(type=ScriptLanguage.class)
    public static class FooScriptLanguage
    extends AbstractScriptLanguage {
        public List<String> getExtensions() {
            return Arrays.asList("foo");
        }

        public ScriptEngine getScriptEngine() {
            throw new IllegalStateException();
        }
    }
}

