/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.Optional;
import org.scijava.module.AbstractModuleItem;
import org.scijava.module.ModuleInfo;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.util.ConversionUtils;
import org.scijava.util.GenericUtils;

public class CommandModuleItem<T>
extends AbstractModuleItem<T> {
    private final Field field;

    public CommandModuleItem(ModuleInfo info, Field field) {
        super(info);
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public Parameter getParameter() {
        return this.field.getAnnotation(Parameter.class);
    }

    @Override
    public Class<T> getType() {
        Class<?> type;
        Class<?> typedType = type = GenericUtils.getFieldClasses(this.field, this.getDelegateClass()).get(0);
        return typedType;
    }

    @Override
    public Type getGenericType() {
        return GenericUtils.getFieldType(this.field, this.getDelegateClass());
    }

    @Override
    public ItemIO getIOType() {
        return this.getParameter().type();
    }

    @Override
    public ItemVisibility getVisibility() {
        return this.getParameter().visibility();
    }

    @Override
    public boolean isAutoFill() {
        return this.getParameter().autoFill();
    }

    @Override
    public boolean isRequired() {
        return this.getParameter().required() && !Optional.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isPersisted() {
        return this.getParameter().persist();
    }

    @Override
    public String getPersistKey() {
        return this.getParameter().persistKey();
    }

    @Override
    public String getInitializer() {
        return this.getParameter().initializer();
    }

    @Override
    public String getCallback() {
        return this.getParameter().callback();
    }

    @Override
    public String getWidgetStyle() {
        return this.getParameter().style();
    }

    @Override
    public T getMinimumValue() {
        return this.tValue(this.getParameter().min());
    }

    @Override
    public T getMaximumValue() {
        return this.tValue(this.getParameter().max());
    }

    @Override
    public Number getStepSize() {
        String value = this.getParameter().stepSize();
        try {
            double stepSize = Double.parseDouble(value);
            return stepSize;
        }
        catch (NumberFormatException exc) {
            return this.tValue(value, Number.class);
        }
    }

    @Override
    public int getColumnCount() {
        return this.getParameter().columns();
    }

    @Override
    public List<T> getChoices() {
        String[] choices = this.getParameter().choices();
        if (choices.length == 0) {
            return super.getChoices();
        }
        ArrayList<T> choiceList = new ArrayList<T>();
        for (String choice : choices) {
            choiceList.add(this.tValue(choice));
        }
        return choiceList;
    }

    @Override
    public String getLabel() {
        return this.getParameter().label();
    }

    @Override
    public String getDescription() {
        return this.getParameter().description();
    }

    @Override
    public boolean is(String key) {
        for (Attr attr : this.getParameter().attrs()) {
            if (!attr.name().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(String key) {
        for (Attr attr : this.getParameter().attrs()) {
            if (!attr.name().equals(key)) continue;
            return attr.value();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    private T tValue(String value) {
        return this.tValue(value, this.getType());
    }

    private <D> D tValue(String value, Class<D> type) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        Class<D> saneType = ConversionUtils.getNonprimitiveType(type);
        return ConversionUtils.convert((Object)value, saneType);
    }
}

