/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Gateway;
import org.scijava.InstantiableException;
import org.scijava.MenuPath;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleService;
import org.scijava.object.LazyObjects;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptFinder;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptLanguageIndex;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.service.Service;
import org.scijava.service.event.ServicesLoadedEvent;
import org.scijava.util.AppUtils;
import org.scijava.util.ClassUtils;
import org.scijava.util.ColorRGB;
import org.scijava.util.ColorRGBA;

@Plugin(type=Service.class, priority=100.0)
public class DefaultScriptService
extends AbstractSingletonService<ScriptLanguage>
implements ScriptService {
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private LogService log;
    private ScriptLanguageIndex scriptLanguageIndex;
    private ArrayList<File> scriptDirs;
    private HashMap<File, MenuPath> menuPrefixes;
    private HashMap<File, ScriptInfo> scripts;
    private HashMap<String, Class<?>> aliasMap;

    @Override
    public ScriptLanguageIndex getIndex() {
        return this.scriptLanguageIndex();
    }

    @Override
    public List<ScriptLanguage> getLanguages() {
        return new ArrayList<ScriptLanguage>(this.getIndex());
    }

    @Override
    public ScriptLanguage getLanguageByExtension(String extension) {
        return this.getIndex().getByExtension(extension);
    }

    @Override
    public ScriptLanguage getLanguageByName(String name) {
        return this.getIndex().getByName(name);
    }

    @Override
    public List<File> getScriptDirectories() {
        return Collections.unmodifiableList(this.scriptDirs());
    }

    @Override
    public MenuPath getMenuPrefix(File scriptDirectory) {
        return this.menuPrefixes().get(scriptDirectory);
    }

    @Override
    public void addScriptDirectory(File scriptDirectory) {
        this.scriptDirs().add(scriptDirectory);
    }

    @Override
    public void addScriptDirectory(File scriptDirectory, MenuPath menuPrefix) {
        this.scriptDirs().add(scriptDirectory);
        this.menuPrefixes().put(scriptDirectory, menuPrefix);
    }

    @Override
    public void removeScriptDirectory(File scriptDirectory) {
        this.scriptDirs().remove(scriptDirectory);
    }

    @Override
    public Collection<ScriptInfo> getScripts() {
        return Collections.unmodifiableCollection(this.scripts().values());
    }

    @Override
    public ScriptInfo getScript(File scriptFile) {
        return this.getOrCreate(scriptFile);
    }

    @Override
    public Future<ScriptModule> run(File file, boolean process, Object ... inputs) {
        return this.run(this.getOrCreate(file), process, inputs);
    }

    @Override
    public Future<ScriptModule> run(File file, boolean process, Map<String, Object> inputMap) {
        return this.run(this.getOrCreate(file), process, inputMap);
    }

    @Override
    public Future<ScriptModule> run(String path, String script, boolean process, Object ... inputs) {
        return this.run(path, (Reader)new StringReader(script), process, inputs);
    }

    @Override
    public Future<ScriptModule> run(String path, String script, boolean process, Map<String, Object> inputMap) {
        return this.run(path, (Reader)new StringReader(script), process, inputMap);
    }

    @Override
    public Future<ScriptModule> run(String path, Reader reader, boolean process, Object ... inputs) {
        return this.run(new ScriptInfo(this.getContext(), path, reader), process, inputs);
    }

    @Override
    public Future<ScriptModule> run(String path, Reader reader, boolean process, Map<String, Object> inputMap) {
        return this.run(new ScriptInfo(this.getContext(), path, reader), process, inputMap);
    }

    @Override
    public Future<ScriptModule> run(ScriptInfo info, boolean process, Object ... inputs) {
        return this.cast(this.moduleService.run(info, process, inputs));
    }

    @Override
    public Future<ScriptModule> run(ScriptInfo info, boolean process, Map<String, Object> inputMap) {
        return this.cast(this.moduleService.run(info, process, inputMap));
    }

    @Override
    public boolean canHandleFile(File file) {
        return this.getIndex().canHandleFile(file);
    }

    @Override
    public boolean canHandleFile(String fileName) {
        return this.getIndex().canHandleFile(fileName);
    }

    @Override
    public void addAlias(Class<?> type) {
        this.addAlias(type.getSimpleName(), type);
    }

    @Override
    public void addAlias(String alias, Class<?> type) {
        this.aliasMap().put(alias, type);
    }

    @Override
    public synchronized Class<?> lookupClass(String alias) throws ScriptException {
        Class<?> type = this.aliasMap().get(alias);
        if (type != null) {
            return type;
        }
        Class<?> c = ClassUtils.loadClass(alias);
        if (c != null) {
            this.aliasMap().put(alias, c);
            return c;
        }
        throw new ScriptException("Unknown type: " + alias);
    }

    @Override
    public Class<ScriptLanguage> getPluginType() {
        return ScriptLanguage.class;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.moduleService.getIndex().addLater(new LazyObjects<ScriptInfo>(){

            @Override
            public Collection<ScriptInfo> get() {
                return DefaultScriptService.this.scripts().values();
            }
        });
    }

    @EventHandler
    private void onEvent(ServicesLoadedEvent evt) {
        for (Service service : this.getContext().getServiceIndex()) {
            this.addAliases(this.aliasMap(), service.getClass());
        }
    }

    private ScriptLanguageIndex scriptLanguageIndex() {
        if (this.scriptLanguageIndex == null) {
            this.initScriptLanguageIndex();
        }
        return this.scriptLanguageIndex;
    }

    private List<File> scriptDirs() {
        if (this.scriptDirs == null) {
            this.initScriptDirs();
        }
        return this.scriptDirs;
    }

    private HashMap<File, MenuPath> menuPrefixes() {
        if (this.menuPrefixes == null) {
            this.initMenuPrefixes();
        }
        return this.menuPrefixes;
    }

    private HashMap<File, ScriptInfo> scripts() {
        if (this.scripts == null) {
            this.initScripts();
        }
        return this.scripts;
    }

    private HashMap<String, Class<?>> aliasMap() {
        if (this.aliasMap == null) {
            this.initAliasMap();
        }
        return this.aliasMap;
    }

    private synchronized void initScriptLanguageIndex() {
        if (this.scriptLanguageIndex != null) {
            return;
        }
        ScriptLanguageIndex index = new ScriptLanguageIndex(this.log);
        for (ScriptLanguage language : this.getInstances()) {
            index.add(language, false);
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            index.add(factory, true);
        }
        this.scriptLanguageIndex = index;
    }

    private synchronized void initScriptDirs() {
        if (this.scriptDirs != null) {
            return;
        }
        ArrayList<File> dirs = new ArrayList<File>();
        File baseDir = AppUtils.getBaseDirectory(this.getClass());
        dirs.add(new File(baseDir, "scripts"));
        String scriptsPath = System.getProperty("scijava.scripts.path");
        if (scriptsPath != null) {
            for (String dir : scriptsPath.split(File.pathSeparator)) {
                dirs.add(new File(dir));
            }
        }
        this.scriptDirs = dirs;
    }

    private synchronized void initMenuPrefixes() {
        if (this.menuPrefixes != null) {
            return;
        }
        this.menuPrefixes = new HashMap();
    }

    private synchronized void initScripts() {
        if (this.scripts != null) {
            return;
        }
        HashMap<File, ScriptInfo> map = new HashMap<File, ScriptInfo>();
        ArrayList<ScriptInfo> scriptList = new ArrayList<ScriptInfo>();
        new ScriptFinder(this).findScripts(scriptList);
        for (ScriptInfo info : scriptList) {
            map.put(this.asFile(info.getPath()), info);
        }
        this.scripts = map;
    }

    private synchronized void initAliasMap() {
        if (this.aliasMap != null) {
            return;
        }
        HashMap map = new HashMap();
        this.addAliases(map, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE);
        this.addAliases(map, Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class);
        this.addAliases(map, Context.class, BigDecimal.class, BigInteger.class, ColorRGB.class, ColorRGBA.class, File.class, String.class);
        List<PluginInfo<Gateway>> gatewayPlugins = this.pluginService.getPluginsOfType(Gateway.class);
        for (PluginInfo<Gateway> info : gatewayPlugins) {
            try {
                this.addAliases(map, info.loadClass());
            }
            catch (InstantiableException exc) {
                this.log.warn("Ignoring invalid gateway: " + info.getClassName(), exc);
            }
        }
        this.aliasMap = map;
    }

    private void addAliases(HashMap<String, Class<?>> map, Class<?> ... types) {
        for (Class<?> type : types) {
            this.addAlias(map, type);
        }
    }

    private void addAlias(HashMap<String, Class<?>> map, Class<?> type) {
        if (type == null) {
            return;
        }
        map.put(type.getSimpleName(), type);
        this.addAlias(map, type.getSuperclass());
        this.addAliases(map, type.getInterfaces());
    }

    private ScriptInfo getOrCreate(File file) {
        ScriptInfo info = this.scripts().get(file);
        if (info != null) {
            return info;
        }
        return new ScriptInfo(this.getContext(), file);
    }

    private File asFile(String path) {
        File file = new File(path);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException exc) {
            this.log.warn(exc);
            return file.getAbsoluteFile();
        }
    }

    private Future<ScriptModule> cast(Future<Module> future) {
        return future;
    }
}

