/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;

public class ColorRGBTest {
    @Test
    public void testHashCode() {
        Assert.assertNotSame((Object)new ColorRGB(1, 2, 3).hashCode(), (Object)new ColorRGB(3, 2, 1));
    }

    @Test
    public void testColorRGBIntIntInt() {
        Assert.assertEquals((long)1L, (long)new ColorRGB(1, 2, 3).getRed());
        Assert.assertEquals((long)2L, (long)new ColorRGB(1, 2, 3).getGreen());
        Assert.assertEquals((long)3L, (long)new ColorRGB(1, 2, 3).getBlue());
    }

    @Test
    public void testColorRGBString() {
        Assert.assertEquals((long)1L, (long)new ColorRGB("1,2,3").getRed());
        Assert.assertEquals((long)2L, (long)new ColorRGB("1,2,3").getGreen());
        Assert.assertEquals((long)3L, (long)new ColorRGB("1,2,3").getBlue());
    }

    @Test
    public void testGetRed() {
    }

    @Test
    public void testGetGreen() {
    }

    @Test
    public void testGetBlue() {
    }

    @Test
    public void testGetAlpha() {
        Assert.assertEquals((long)255L, (long)new ColorRGB(1, 2, 3).getAlpha());
    }

    @Test
    public void testGetARGB() {
        Assert.assertEquals((long)-16711165L, (long)new ColorRGB(1, 2, 3).getARGB());
    }

    @Test
    public void testToHTMLColor() {
        Assert.assertEquals((Object)"#010203", (Object)new ColorRGB(1, 2, 3).toHTMLColor());
        Assert.assertEquals((Object)"red", (Object)new ColorRGB(255, 0, 0).toHTMLColor());
        Assert.assertEquals((Object)"red", (Object)Colors.RED.toHTMLColor());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"1,2,3", (Object)new ColorRGB("1,2,3").toString());
    }

    @Test
    public void testEqualsObject() {
        Assert.assertEquals((Object)new ColorRGB(1, 2, 3), (Object)new ColorRGB(1, 2, 3));
        Assert.assertFalse((boolean)new ColorRGB(1, 2, 3).equals((Object)new ColorRGB(3, 2, 1)));
    }

    @Test
    public void testFromHTMLColor() {
        Assert.assertEquals((Object)new ColorRGB(1, 2, 3), (Object)ColorRGB.fromHTMLColor((String)"#010203"));
        Assert.assertEquals((Object)new ColorRGB(255, 0, 0), (Object)ColorRGB.fromHTMLColor((String)"red"));
        Assert.assertSame((Object)Colors.RED, (Object)ColorRGB.fromHTMLColor((String)"red"));
        Assert.assertNotSame((Object)Colors.RED, (Object)ColorRGB.fromHTMLColor((String)"green"));
    }
}

