/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.util.Objects;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.ReadBufferDataHandle;
import org.scijava.io.handle.WriteBufferDataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.WrapperService;
import org.scijava.service.SciJavaService;

public interface DataHandleService
extends WrapperService<Location, DataHandle<Location>>,
SciJavaService {
    @Override
    default public Class<DataHandle<Location>> getPluginType() {
        return DataHandle.class;
    }

    @Override
    default public Class<Location> getType() {
        return Location.class;
    }

    default public boolean exists(Location location) throws IOException {
        try (DataHandle handle = (DataHandle)this.create(location);){
            boolean bl = handle.exists();
            return bl;
        }
    }

    default public DataHandle<Location> readBuffer(DataHandle<Location> handle) {
        Objects.nonNull(handle);
        return new ReadBufferDataHandle(handle);
    }

    default public DataHandle<Location> readBuffer(Location location) {
        DataHandle handle = (DataHandle)this.create(location);
        return handle == null ? null : new ReadBufferDataHandle(handle);
    }

    default public DataHandle<Location> writeBuffer(DataHandle<Location> handle) {
        Objects.nonNull(handle);
        return new WriteBufferDataHandle(handle);
    }
}

