/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.POM;
import org.scijava.util.XML;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class POMTest {
    @Test
    public void testCompareVersions() {
        Assert.assertTrue((POM.compareVersions((String)"1", (String)"2") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0", (String)"2.0") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0", (String)"1.1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0.0", (String)"2.0.0") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"2", (String)"1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"2.0", (String)"1.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.1", (String)"1.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"2.0.0", (String)"1.0.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0-RC1", (String)"1.0-RC2") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0-RC-1", (String)"1.0-RC-2") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0-RC-2", (String)"1.0-RC-10") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"0.4-alpha", (String)"0.4-beta") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"foo", (String)"bar") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0-RC2", (String)"1.0-RC10") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"1.0-rc1", (String)"1.0-RC2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"2.0.0", (String)"2.0.0.1") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((POM.compareVersions((String)"2.0.0", (String)"2.0.0-beta-1") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAccessors() throws ParserConfigurationException, SAXException, IOException {
        POM pom = new POM(new File("pom.xml"));
        Assert.assertEquals((Object)"org.scijava", (Object)pom.getParentGroupId());
        Assert.assertEquals((Object)"pom-scijava", (Object)pom.getParentArtifactId());
        Assert.assertNotNull((Object)pom.getParentVersion());
        Assert.assertEquals((Object)"org.scijava", (Object)pom.getGroupId());
        Assert.assertEquals((Object)"scijava-common", (Object)pom.getArtifactId());
        Assert.assertNotNull((Object)pom.getVersion());
        Assert.assertEquals((Object)"Travis CI", (Object)pom.getCIManagementSystem());
        String ciManagementURL = pom.getCIManagementURL();
        Assert.assertEquals((Object)"https://travis-ci.org/scijava/scijava-common", (Object)ciManagementURL);
        Assert.assertEquals((Object)"GitHub Issues", (Object)pom.getIssueManagementSystem());
        String issueManagementURL = pom.getIssueManagementURL();
        Assert.assertEquals((Object)"https://github.com/scijava/scijava-common/issues", (Object)issueManagementURL);
        Assert.assertEquals((Object)"SciJava", (Object)pom.getOrganizationName());
        Assert.assertEquals((Object)"https://scijava.org/", (Object)pom.getOrganizationURL());
        Assert.assertTrue((boolean)pom.getPath().endsWith("pom.xml"));
        Assert.assertTrue((boolean)pom.getProjectDescription().startsWith("SciJava Common is a shared library for SciJava software."));
        Assert.assertEquals((Object)"2009", (Object)pom.getProjectInceptionYear());
        Assert.assertEquals((Object)"SciJava Common", (Object)pom.getProjectName());
        Assert.assertEquals((Object)"https://github.com/scijava/scijava-common", (Object)pom.getProjectURL());
        String scmConnection = pom.getSCMConnection();
        Assert.assertEquals((Object)"scm:git:git://github.com/scijava/scijava-common", (Object)scmConnection);
        String scmDeveloperConnection = pom.getSCMDeveloperConnection();
        Assert.assertEquals((Object)"scm:git:git@github.com:scijava/scijava-common", (Object)scmDeveloperConnection);
        Assert.assertNotNull((Object)pom.getSCMTag());
        Assert.assertEquals((Object)"https://github.com/scijava/scijava-common", (Object)pom.getSCMURL());
    }

    @Test
    public void testCdata() throws ParserConfigurationException, SAXException, IOException {
        POM pom = new POM(new File("pom.xml"));
        Assert.assertEquals((Object)"repo", (Object)pom.cdata("//project/licenses/license/distribution"));
        Assert.assertEquals((Object)"https://github.com/scijava/scijava-common", (Object)pom.cdata("//project/url"));
    }

    @Test
    public void testElements() throws ParserConfigurationException, SAXException, IOException {
        POM pom = new POM(new File("pom.xml"));
        ArrayList developers = pom.elements("//project/developers/developer");
        Assert.assertEquals((long)1L, (long)developers.size());
        Assert.assertEquals((Object)"ctrueden", (Object)XML.cdata((Element)((Element)developers.get(0)), (String)"id"));
    }
}

