/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.convert.DefaultConverter;

public class DefaultConverterTest {
    private DefaultConverter converter;

    @Before
    public void setUp() {
        this.converter = new DefaultConverter();
    }

    @Test
    public void testObjectToObjectArray() {
        Object o = new Object();
        Object[] result = (Object[])this.converter.convert(o, Object[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
    }

    @Test
    public void testIntToObjectArray() {
        int v = 1;
        Object[] result = (Object[])this.converter.convert((Object)v, Object[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
    }

    @Test
    public void testIntToPrimitiveIntArray() {
        int v = 2;
        int[] result = (int[])this.converter.convert((Object)v, int[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertSame((Object)v, (Object)result[0]);
    }

    @Test
    public void testIntToBoxedIntegerArray() {
        int v = 3;
        Integer[] result = (Integer[])this.converter.convert((Object)v, Integer[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertSame((Object)v, (Object)result[0]);
    }

    @Test
    public void testByteToPrimitiveDoubleArray() {
        byte v = 4;
        double[] result = (double[])this.converter.convert((Object)v, double[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((double)v, (double)result[0], (double)0.0);
    }

    @Test
    public void testByteToBoxedDoubleArray() {
        byte v = 4;
        Double[] result = (Double[])this.converter.convert((Object)v, Double[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((double)v, (double)result[0], (double)0.0);
    }

    @Test
    public void testStringToObjectArray() {
        String s = "Pumpernickel";
        Object[] result = (Object[])this.converter.convert((Object)s, Object[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
    }

    @Test
    public void testStringToStringArray() {
        String s = "smorgasbord";
        String[] result = (String[])this.converter.convert((Object)s, String[].class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertSame((Object)s, (Object)result[0]);
    }

    @Test
    public void testObjectToCollection() throws NoSuchFieldException {
        class Struct {
            private Collection<Object> collectionOfObjects;
            private List<Object> listOfObjects;
            private List<String> listOfStrings;
            private List<Double> listOfDoubles;
            private Set<Object> setOfObjects;

            Struct() {
            }
        }
        Type collectionOfObjectsType = Struct.class.getDeclaredField("collectionOfObjects").getGenericType();
        Type listOfObjectsType = Struct.class.getDeclaredField("listOfObjects").getGenericType();
        Type listOfStringsType = Struct.class.getDeclaredField("listOfStrings").getGenericType();
        Type listOfDoublesType = Struct.class.getDeclaredField("listOfDoubles").getGenericType();
        Type setOfObjectsType = Struct.class.getDeclaredField("setOfObjects").getGenericType();
        Object o = new Object();
        Assert.assertTrue((boolean)this.converter.canConvert(o, listOfObjectsType));
        Assert.assertTrue((boolean)this.converter.canConvert(o, listOfStringsType));
        Assert.assertTrue((boolean)this.converter.canConvert(o, listOfDoublesType));
        Assert.assertTrue((boolean)this.converter.canConvert(o, setOfObjectsType));
        String s = "Thingamawhatsit";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, listOfObjectsType));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, listOfStringsType));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, listOfDoublesType));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, setOfObjectsType));
        DefaultConverterTest.assertCollection(s, this.converter.convert((Object)s, listOfStringsType), List.class);
    }

    @Test
    public void testNumberToNumber() {
        double d = -5.6;
        Assert.assertTrue((boolean)this.converter.canConvert((Object)d, Integer.TYPE));
        Assert.assertEquals((double)-5.0, (double)((Integer)this.converter.convert((Object)d, Integer.TYPE)).intValue(), (double)0.0);
    }

    @Test
    public void testObjectToString() {
        Object friendly = new Object(){

            public String toString() {
                return "Hello";
            }
        };
        Assert.assertTrue((boolean)this.converter.canConvert(friendly, String.class));
        Assert.assertEquals((Object)"Hello", (Object)this.converter.convert(friendly, String.class));
    }

    @Test
    public void testStringToCharacter() {
        String plan = "Step 0: there is no plan";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)plan, Character.TYPE));
        Assert.assertEquals((long)83L, (long)((Character)this.converter.convert((Object)plan, Character.TYPE)).charValue());
        Assert.assertTrue((boolean)this.converter.canConvert((Object)plan, Character.class));
        Assert.assertEquals((Object)new Character('S'), (Object)this.converter.convert((Object)plan, Character.class));
    }

    @Test
    public void testStringToCharacterArray() {
        String plan = "Step 0: there is no plan";
    }

    @Test
    public void testStringToEnum() {
        Assert.assertTrue((boolean)this.converter.canConvert((Object)"RUBY", Gem.class));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)"DIAMOND", Gem.class));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)"EMERALD", Gem.class));
        Assert.assertTrue((boolean)this.converter.canConvert((Object)"QUARTZ", Gem.class));
        Assert.assertEquals((Object)((Object)Gem.RUBY), (Object)this.converter.convert((Object)"RUBY", Gem.class));
        Assert.assertEquals((Object)((Object)Gem.DIAMOND), (Object)this.converter.convert((Object)"DIAMOND", Gem.class));
        Assert.assertEquals((Object)((Object)Gem.EMERALD), (Object)this.converter.convert((Object)"EMERALD", Gem.class));
        Assert.assertNull((Object)this.converter.convert((Object)"QUARTZ", Gem.class));
    }

    @Test
    public void testConstructorConversion() {
        String s = "Juggernaut";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, StringWrapper.class));
        Assert.assertFalse((boolean)this.converter.canConvert((Object)7, StringWrapper.class));
        StringWrapper sw = (StringWrapper)this.converter.convert((Object)s, StringWrapper.class);
        Assert.assertNotNull((Object)sw);
        Assert.assertSame((Object)s, (Object)sw.s);
    }

    private static void assertCollection(Object o, Object collection, Class<?> collectionClass) {
        Assert.assertNotNull((Object)collection);
        Assert.assertTrue((boolean)collectionClass.isInstance(collection));
        Assert.assertEquals((long)1L, (long)((Collection)collection).size());
        Assert.assertSame((Object)o, ((Collection)collection).iterator().next());
    }

    public static class StringWrapper {
        public String s;

        public StringWrapper(String s) {
            this.s = s;
        }
    }

    private static enum Gem {
        RUBY,
        DIAMOND,
        EMERALD;

    }
}

