/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.Test;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleTest;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;

public class WriteBufferDataHandleTest
extends DataHandleTest {
    @Override
    public Class<? extends DataHandle<?>> getExpectedHandleType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location createLocation() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataHandle<? extends Location> createHandle() {
        DataHandle handle = (DataHandle)this.dataHandleService.create((Object)new BytesLocation(new byte[42]));
        return this.dataHandleService.writeBuffer(handle);
    }

    @Override
    @Test
    public void testReading() throws IOException {
    }

    @Override
    @Test
    public void checkSkip() throws IOException {
    }

    @Test(expected=IOException.class)
    public void ensureNotReadable() throws IOException {
        this.createHandle().read();
    }

    @Override
    @Test
    public void testWriting() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(42);
        this.populateData(os);
        BytesLocation location = new BytesLocation(os.toByteArray());
        DataHandle handle = (DataHandle)this.dataHandleService.create((Object)location);
        DataHandle writeHandle = this.dataHandleService.writeBuffer(handle);
        this.checkBasicWrites(handle, writeHandle);
    }

    @Test
    public void testEndiannessWriting() throws IOException {
        BytesLocation location = new BytesLocation(new byte[42]);
        Supplier readHandleSupplier = () -> (DataHandle)this.dataHandleService.create((Object)location);
        Supplier writeHandleSupplier = () -> {
            DataHandle h = (DataHandle)this.dataHandleService.create((Object)location);
            return this.dataHandleService.writeBuffer(h);
        };
        this.checkWriteEndianes(readHandleSupplier, writeHandleSupplier, DataHandle.ByteOrder.LITTLE_ENDIAN);
        this.checkWriteEndianes(readHandleSupplier, writeHandleSupplier, DataHandle.ByteOrder.LITTLE_ENDIAN);
        this.checkAdvancedStringWriting(readHandleSupplier, writeHandleSupplier);
    }
}

