/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.Types;

public class GenericArrayTypesTest {
    @Test
    public void testArrayFields() throws NoSuchFieldException, SecurityException {
        Field rawField = Types.field(ClassWithFields.class, (String)"rawListArray");
        Field genericWildcardField = Types.field(ClassWithFields.class, (String)"wildcardListArray");
        Field genericTypedField = Types.field(ClassWithFields.class, (String)"integerListArray");
        Type rawFieldType = Types.fieldType((Field)rawField, ClassWithFields.class);
        Type genericWildcardFieldType = Types.fieldType((Field)genericWildcardField, ClassWithFields.class);
        Type genericTypedFieldType = Types.fieldType((Field)genericTypedField, ClassWithFields.class);
        Assert.assertFalse((boolean)(rawFieldType instanceof GenericArrayType));
        Assert.assertTrue((boolean)(rawFieldType instanceof Class));
        Assert.assertTrue((boolean)(genericWildcardFieldType instanceof GenericArrayType));
        Assert.assertTrue((boolean)(genericTypedFieldType instanceof GenericArrayType));
        Assert.assertEquals((Object)rawField.getGenericType(), (Object)rawFieldType);
        Assert.assertEquals((Object)genericWildcardField.getGenericType(), (Object)genericWildcardFieldType);
        Assert.assertEquals((Object)genericTypedField.getGenericType(), (Object)genericTypedFieldType);
        Assert.assertSame(List[].class, (Object)Types.raw((Type)rawFieldType));
        Assert.assertSame(List[].class, (Object)Types.raw((Type)genericWildcardFieldType));
        Assert.assertSame(List[].class, (Object)Types.raw((Type)genericTypedFieldType));
    }

    private static class ClassWithFields {
        public List[] rawListArray;
        public List<?>[] wildcardListArray;
        public List<Integer>[] integerListArray;

        private ClassWithFields() {
        }
    }
}

