/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.io.File;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=PreprocessorPlugin.class, priority=-9999.0)
public class FileListPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private UIService uiService;

    @Override
    public void process(Module module) {
        if (this.uiService == null) {
            return;
        }
        ModuleItem<File[]> fileInput = this.getFilesInput(module);
        if (fileInput == null) {
            return;
        }
        File[] files = fileInput.getValue(module);
        File[] result = this.uiService.chooseFiles(null, files, null, fileInput.getWidgetStyle());
        if (result == null) {
            this.cancel("");
            return;
        }
        fileInput.setValue(module, result);
        module.resolveInput(fileInput.getName());
    }

    private ModuleItem<File[]> getFilesInput(Module module) {
        ModuleItem<?> result = null;
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            ModuleItem<?> fileInput;
            if (module.isInputResolved(input.getName())) continue;
            Class<?> type = input.getType();
            if (!File[].class.isAssignableFrom(type)) {
                return null;
            }
            if (result != null) {
                return null;
            }
            result = fileInput = input;
        }
        return result;
    }
}

