/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.parse.ParseService;

public class FileToPathConversionTest {
    private ConvertService convertService;
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ParseService.class, ConvertService.class});
        this.convertService = (ConvertService)this.context.getService(ConvertService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void fileToPathConversion() {
        File f = new File("tmp.java");
        Assert.assertTrue((boolean)this.convertService.supports((Object)f, Path.class));
        Path p = (Path)this.convertService.convert((Object)f, Path.class);
        Assert.assertEquals((Object)f.toPath(), (Object)p);
    }

    @Test
    public void pathToFileConversion() {
        Path p = Paths.get("tmp.java", new String[0]);
        Assert.assertTrue((boolean)this.convertService.supports((Object)p, File.class));
        File f = (File)this.convertService.convert((Object)p, File.class);
        Assert.assertEquals((Object)f.toPath(), (Object)p);
    }
}

