/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.console;

import java.io.IOException;
import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.display.DisplayService;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.startup.StartupService;

@Plugin(type=ConsoleArgument.class)
public class OpenArgument
extends AbstractConsoleArgument {
    @Parameter(required=false)
    private IOService ioService;
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private StartupService startupService;
    @Parameter(required=false)
    private LogService log;

    public OpenArgument() {
        super(2, "--open");
    }

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String source = args.removeFirst();
        this.startupService.addOperation(() -> {
            block2: {
                try {
                    Object o = this.ioService.open(source);
                    this.displayService.createDisplay(o);
                }
                catch (IOException exc) {
                    if (this.log == null) break block2;
                    this.log.error(exc);
                }
            }
        });
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        return this.startupService != null && this.ioService != null && this.displayService != null && super.supports(args);
    }
}

