/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Classes;
import org.scijava.testutil.ExampleTypes;

public class ClassesTest {
    @Test
    public void testLoad() {
        this.assertLoaded(Boolean.TYPE, "boolean");
        this.assertLoaded(Byte.TYPE, "byte");
        this.assertLoaded(Character.TYPE, "char");
        this.assertLoaded(Double.TYPE, "double");
        this.assertLoaded(Float.TYPE, "float");
        this.assertLoaded(Integer.TYPE, "int");
        this.assertLoaded(Long.TYPE, "long");
        this.assertLoaded(Short.TYPE, "short");
        this.assertLoaded(Void.TYPE, "void");
        this.assertLoaded(String.class, "string");
        this.assertLoaded(Number.class, "java.lang.Number");
        this.assertLoaded(boolean[].class, "boolean[]");
        this.assertLoaded(byte[].class, "byte[]");
        this.assertLoaded(char[].class, "char[]");
        this.assertLoaded(double[].class, "double[]");
        this.assertLoaded(float[].class, "float[]");
        this.assertLoaded(int[].class, "int[]");
        this.assertLoaded(long[].class, "long[]");
        this.assertLoaded(short[].class, "short[]");
        this.assertLoaded(null, "void[]");
        this.assertLoaded(String[].class, "string[]");
        this.assertLoaded(Number[].class, "java.lang.Number[]");
        this.assertLoaded(boolean[][].class, "boolean[][]");
        this.assertLoaded(byte[][].class, "byte[][]");
        this.assertLoaded(char[][].class, "char[][]");
        this.assertLoaded(double[][].class, "double[][]");
        this.assertLoaded(float[][].class, "float[][]");
        this.assertLoaded(int[][].class, "int[][]");
        this.assertLoaded(long[][].class, "long[][]");
        this.assertLoaded(short[][].class, "short[][]");
        this.assertLoaded(null, "void[][]");
        this.assertLoaded(String[][].class, "string[][]");
        this.assertLoaded(Number[][].class, "java.lang.Number[][]");
        this.assertLoaded(boolean[].class, "[Z");
        this.assertLoaded(byte[].class, "[B");
        this.assertLoaded(char[].class, "[C");
        this.assertLoaded(double[].class, "[D");
        this.assertLoaded(float[].class, "[F");
        this.assertLoaded(int[].class, "[I");
        this.assertLoaded(long[].class, "[J");
        this.assertLoaded(short[].class, "[S");
        this.assertLoaded(null, "[V");
        this.assertLoaded(String[].class, "[Lstring;");
        this.assertLoaded(Number[].class, "[Ljava.lang.Number;");
        this.assertLoaded(boolean[][].class, "[[Z");
        this.assertLoaded(byte[][].class, "[[B");
        this.assertLoaded(char[][].class, "[[C");
        this.assertLoaded(double[][].class, "[[D");
        this.assertLoaded(float[][].class, "[[F");
        this.assertLoaded(int[][].class, "[[I");
        this.assertLoaded(long[][].class, "[[J");
        this.assertLoaded(short[][].class, "[[S");
        this.assertLoaded(null, "[[V");
        this.assertLoaded(String[][].class, "[[Lstring;");
        this.assertLoaded(Number[][].class, "[[Ljava.lang.Number;");
    }

    @Test
    public void testLoadFailureQuiet() {
        Assertions.assertNull((Object)Classes.load((String)"a.non.existent.class"));
    }

    @Test
    public void testLoadFailureLoud() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Classes.load((String)"a.non.existent.class", (boolean)false));
    }

    @Test
    public void testLocationUnpackedClass() throws IOException, URISyntaxException {
        String path;
        File tmpDir = Files.createTempDirectory("class-utils-test", new FileAttribute[0]).toFile();
        File classFile = new File(tmpDir, path = this.getClass().getName().replace('.', '/') + ".class");
        Assertions.assertTrue((classFile.getParentFile().exists() || classFile.getParentFile().mkdirs() ? 1 : 0) != 0);
        URL url = Objects.requireNonNull(this.getClass().getResource("/" + path));
        this.copy(url.openStream(), new FileOutputStream(classFile));
        URLClassLoader classLoader = new URLClassLoader(new URL[]{tmpDir.toURI().toURL()}, null);
        Class c = Classes.load((String)this.getClass().getName(), (ClassLoader)classLoader);
        URL location = Classes.location((Class)c);
        File actual = new File(location.toURI());
        actual.deleteOnExit();
        Assertions.assertEquals((Object)tmpDir, (Object)new File(location.toURI()));
    }

    @Test
    public void testLocationClassInJar() throws IOException, URISyntaxException {
        File tmpDir = Files.createTempDirectory("class-utils-test", new FileAttribute[0]).toFile();
        File jar = new File(tmpDir, "test.jar");
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jar));
        String path = this.getClass().getName().replace('.', '/') + ".class";
        out.putNextEntry(new ZipEntry(path));
        URL url = Objects.requireNonNull(this.getClass().getResource("/" + path));
        this.copy(url.openStream(), out);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()}, null);
        Class c = Classes.load((String)this.getClass().getName(), (ClassLoader)classLoader);
        URL location = Classes.location((Class)c);
        Assertions.assertEquals((Object)jar, (Object)new File(location.toURI()));
        jar.deleteOnExit();
    }

    @Test
    public void testLocationFailureQuiet() {
        Class<?> weirdClass = this.loadCustomClass();
        Assertions.assertEquals((Object)"Hello", (Object)weirdClass.getName());
        Assertions.assertNull((Object)Classes.location(weirdClass));
    }

    @Test
    public void testLocationFailureLoud() {
        Class<?> weirdClass = this.loadCustomClass();
        Assertions.assertEquals((Object)"Hello", (Object)weirdClass.getName());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Classes.location((Class)weirdClass, (boolean)false));
    }

    @Test
    public void testUnbox() {
        Class[] types;
        Class booleanType = Classes.unbox(Boolean.class);
        Assertions.assertSame(Boolean.TYPE, (Object)booleanType);
        Class byteType = Classes.unbox(Byte.class);
        Assertions.assertSame(Byte.TYPE, (Object)byteType);
        Class charType = Classes.unbox(Character.class);
        Assertions.assertSame(Character.TYPE, (Object)charType);
        Class doubleType = Classes.unbox(Double.class);
        Assertions.assertSame(Double.TYPE, (Object)doubleType);
        Class floatType = Classes.unbox(Float.class);
        Assertions.assertSame(Float.TYPE, (Object)floatType);
        Class intType = Classes.unbox(Integer.class);
        Assertions.assertSame(Integer.TYPE, (Object)intType);
        Class longType = Classes.unbox(Long.class);
        Assertions.assertSame(Long.TYPE, (Object)longType);
        Class shortType = Classes.unbox(Short.class);
        Assertions.assertSame(Short.TYPE, (Object)shortType);
        Class voidType = Classes.unbox(Void.class);
        Assertions.assertSame(Void.TYPE, (Object)voidType);
        for (Class c : types = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Class type = Classes.unbox((Class)c);
            Assertions.assertSame((Object)c, (Object)type);
        }
    }

    @Test
    public void testBox() {
        Class[] types;
        Class booleanType = Classes.box(Boolean.TYPE);
        Assertions.assertSame(Boolean.class, (Object)booleanType);
        Class byteType = Classes.box(Byte.TYPE);
        Assertions.assertSame(Byte.class, (Object)byteType);
        Class charType = Classes.box(Character.TYPE);
        Assertions.assertSame(Character.class, (Object)charType);
        Class doubleType = Classes.box(Double.TYPE);
        Assertions.assertSame(Double.class, (Object)doubleType);
        Class floatType = Classes.box(Float.TYPE);
        Assertions.assertSame(Float.class, (Object)floatType);
        Class intType = Classes.box(Integer.TYPE);
        Assertions.assertSame(Integer.class, (Object)intType);
        Class longType = Classes.box(Long.TYPE);
        Assertions.assertSame(Long.class, (Object)longType);
        Class shortType = Classes.box(Short.TYPE);
        Assertions.assertSame(Short.class, (Object)shortType);
        Class voidType = Classes.box(Void.TYPE);
        Assertions.assertSame(Void.class, (Object)voidType);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Class type = Classes.box((Class)c);
            Assertions.assertSame((Object)c, (Object)type);
        }
    }

    @Test
    public void testNullValue() {
        Class[] types;
        boolean booleanNull = (Boolean)Classes.nullValue(Boolean.TYPE);
        Assertions.assertFalse((boolean)booleanNull);
        byte byteNull = (Byte)Classes.nullValue(Byte.TYPE);
        Assertions.assertEquals((int)0, (int)byteNull);
        char charNull = ((Character)Classes.nullValue(Character.TYPE)).charValue();
        Assertions.assertEquals((char)'\u0000', (char)charNull);
        double doubleNull = (Double)Classes.nullValue(Double.TYPE);
        Assertions.assertEquals((double)0.0, (double)doubleNull, (double)0.0);
        float floatNull = ((Float)Classes.nullValue(Float.TYPE)).floatValue();
        Assertions.assertEquals((float)0.0f, (float)floatNull, (float)0.0f);
        int intNull = (Integer)Classes.nullValue(Integer.TYPE);
        Assertions.assertEquals((int)0, (int)intNull);
        long longNull = (Long)Classes.nullValue(Long.TYPE);
        Assertions.assertEquals((long)0L, (long)longNull);
        short shortNull = (Short)Classes.nullValue(Short.TYPE);
        Assertions.assertEquals((int)0, (int)shortNull);
        Void voidNull = (Void)Classes.nullValue(Void.TYPE);
        Assertions.assertNull((Object)voidNull);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Object nullValue = Classes.nullValue((Class)c);
            Assertions.assertNull((Object)nullValue, (String)("Expected null for " + c.getName()));
        }
    }

    @Test
    public void testField() {
        Field field = Classes.field(ExampleTypes.Thing.class, (String)"thing");
        Assertions.assertEquals((Object)"thing", (Object)field.getName());
        Assertions.assertSame(Object.class, field.getType());
        Assertions.assertTrue((boolean)(field.getGenericType() instanceof TypeVariable));
        Assertions.assertEquals((Object)"T", (Object)((TypeVariable)field.getGenericType()).getName());
    }

    @Test
    public void testMethod() {
        Method objectMethod = Classes.method(ExampleTypes.Thing.class, (String)"toString", (Class[])new Class[0]);
        Assertions.assertSame(Object.class, objectMethod.getDeclaringClass());
        Assertions.assertEquals((Object)"toString", (Object)objectMethod.getName());
        Assertions.assertSame(String.class, objectMethod.getReturnType());
        Assertions.assertEquals((int)0, (int)objectMethod.getParameterTypes().length);
        Method wordsMethod = Classes.method(ExampleTypes.Words.class, (String)"valueOf", (Class[])new Class[]{String.class});
        Assertions.assertSame(ExampleTypes.Words.class, wordsMethod.getDeclaringClass());
        Assertions.assertEquals((Object)"valueOf", (Object)wordsMethod.getName());
        Assertions.assertSame(ExampleTypes.Words.class, wordsMethod.getReturnType());
        Assertions.assertEquals((int)1, (int)wordsMethod.getParameterTypes().length);
        Assertions.assertSame(String.class, wordsMethod.getParameterTypes()[0]);
    }

    @Test
    public void testArray() {
        Assertions.assertSame(boolean[].class, (Object)Classes.array(Boolean.TYPE));
        Assertions.assertSame(String[].class, (Object)Classes.array(String.class));
        Assertions.assertSame(Number[].class, (Object)Classes.array(Number.class));
        Assertions.assertSame(boolean[][].class, (Object)Classes.array(boolean[].class));
        Assertions.assertSame(String[][].class, (Object)Classes.array(String[].class));
        Assertions.assertSame(Number[][].class, (Object)Classes.array(Number[].class));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Classes.array(Void.TYPE), (String)"Unexpected success creating void[]");
        Assertions.assertSame(Number[][].class, (Object)Classes.array(Number.class, (int)2));
        Assertions.assertSame(boolean[][][].class, (Object)Classes.array(Boolean.TYPE, (int)3));
        Assertions.assertSame(String.class, (Object)Classes.array(String.class, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Classes.array(Character.TYPE, (int)-1), (String)"Unexpected success creating negative dimensional array");
    }

    private void assertLoaded(Class<?> c, String name) {
        Assertions.assertSame(c, (Object)Classes.load((String)name));
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        out.close();
    }

    private Class<?> loadCustomClass() {
        byte[] bytecode = new byte[]{-54, -2, -70, -66, 0, 0, 0, 52, 0, 13, 10, 0, 3, 0, 10, 7, 0, 11, 7, 0, 12, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 10, 72, 101, 108, 108, 111, 46, 106, 97, 118, 97, 12, 0, 4, 0, 5, 1, 0, 5, 72, 101, 108, 108, 111, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 33, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 29, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 1, 0, 7, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 1, 0, 8, 0, 0, 0, 2, 0, 9};
        class BytesClassLoader
        extends ClassLoader {
            BytesClassLoader() {
            }

            public Class<?> load(String name, byte[] b) {
                return this.defineClass(name, b, 0, b.length);
            }
        }
        return new BytesClassLoader().load("Hello", bytecode);
    }
}

