/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.scijava.common3.Platforms;

public final class URLs {
    private URLs() {
    }

    public static Collection<URL> listContents(URL directory) {
        return URLs.listContents(directory, true, true);
    }

    public static Collection<URL> listContents(URL directory, boolean recurse, boolean filesOnly) {
        return URLs.appendContents(new ArrayList<URL>(), directory, recurse, filesOnly);
    }

    public static Collection<URL> appendContents(Collection<URL> result, URL directory) {
        return URLs.appendContents(result, directory, true, true);
    }

    public static Collection<URL> appendContents(Collection<URL> result, URL directory, boolean recurse, boolean filesOnly) {
        block18: {
            String protocol;
            block17: {
                if (directory == null) {
                    return result;
                }
                protocol = directory.getProtocol();
                if (!protocol.equals("file")) break block17;
                File dir = URLs.toFile(directory);
                File[] list = dir.listFiles();
                if (list == null) break block18;
                for (File file : list) {
                    try {
                        if (!filesOnly || file.isFile()) {
                            result.add(file.toURI().toURL());
                        }
                        if (!recurse || !file.isDirectory()) continue;
                        URLs.appendContents(result, file.toURI().toURL(), recurse, filesOnly);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                break block18;
            }
            if (protocol.equals("jar")) {
                try {
                    String url = directory.toString();
                    int bang = url.indexOf("!/");
                    if (bang < 0) {
                        return result;
                    }
                    String prefix = url.substring(bang + 2);
                    String baseURL = url.substring(0, bang + 2);
                    JarURLConnection connection = (JarURLConnection)new URL(baseURL).openConnection();
                    try (JarFile jar = connection.getJarFile();){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            int slash;
                            JarEntry entry = entries.nextElement();
                            String urlEncoded = new URI(null, null, entry.getName(), null).toString();
                            if (urlEncoded.length() <= prefix.length() || !urlEncoded.startsWith(prefix) || filesOnly && urlEncoded.endsWith("/") || !recurse && (slash = urlEncoded.indexOf("/", prefix.length())) >= 0 && slash != urlEncoded.length() - 1) continue;
                            result.add(new URL(baseURL + urlEncoded));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return result;
    }

    public static File toFile(URL url) {
        return url == null ? null : URLs.toFile(url.toString());
    }

    public static File toFile(String url) {
        Object path = url;
        if (((String)path).startsWith("jar:")) {
            int index = ((String)path).indexOf("!/");
            path = ((String)path).substring(4, index);
        }
        try {
            if (Platforms.isWindows() && ((String)path).matches("file:[A-Za-z]:.*")) {
                path = "file:/" + ((String)path).substring(5);
            }
            return new File(new URL((String)path).toURI());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            if (((String)path).startsWith("file:")) {
                path = ((String)path).substring(5);
                return new File((String)path);
            }
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
    }
}

