/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.links;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.links.Links;

public class LinksTest {
    private static final URI TEST_URI;

    @Test
    public void testPath() {
        String actual = Links.path((URI)TEST_URI);
        Assert.assertEquals((Object)"op/sub/resource", (Object)actual);
    }

    @Test
    public void testOperation() {
        String actual = Links.operation((URI)TEST_URI);
        Assert.assertEquals((Object)"op", (Object)actual);
    }

    @Test
    public void testPathFragments() {
        Object[] expected = new String[]{"op", "sub", "resource"};
        Object[] actual = Links.pathFragments((URI)TEST_URI);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testSubPath() {
        String actual = Links.subPath((URI)TEST_URI);
        Assert.assertEquals((Object)"sub/resource", (Object)actual);
    }

    @Test
    public void testQuery() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("fruit", "apple");
        expected.put("veggie", "beans");
        Map actual = Links.query((URI)TEST_URI);
        Assert.assertEquals(expected, (Object)actual);
    }

    static {
        try {
            TEST_URI = new URI("scijava://user:pass@example.com:8080/op/sub/resource?fruit=apple&veggie=beans#section");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

